import { create } from 'zustand';
import { userEndpoints } from '../endpoints/user';
import axiosInstance from '@/utils/axios'; // Assurez-vous que ce type existe
import { DateRangeOption, StatusType, WorkStatusDTO } from '@/shared/types/client';



type WorkStatusStore = {
  currentStatus: WorkStatusDTO | null;
  loading: boolean;
  error: string | null;
  createOrUpdateStatus: (data: WorkStatusDTO) => Promise<void>;
  getTodayStatus: (collaboratorId: number) => Promise<void>;
};

export const useWorkStatusStore = create<WorkStatusStore>((set) => ({
  currentStatus: null,
  loading: false,
  error: null,

  createOrUpdateStatus: async (data) => {
    set({ loading: true, error: null });
    try {
      const response = await axiosInstance.post<WorkStatusDTO>(
        userEndpoints.user.workStatus.add,
        data
      );
      set({ currentStatus: response.data, loading: false });
    } catch (error: any) {
      set({ error: error.message || 'Failed to update work status', loading: false });
    }
  },

  getTodayStatus: async (collaboratorId) => {
    set({ loading: true, error: null });
    try {
      const response = await axiosInstance.get<WorkStatusDTO>(
        userEndpoints.user.workStatus.getToday(collaboratorId)
      );
      set({ currentStatus: response.data, loading: false });
    } catch (error: any) {
      set({ error: error.message || 'Failed to fetch work status', loading: false });
    }
  },
}));
