import { create } from 'zustand';
import axiosInstance from '@/utils/axios';
import { ZoneNames } from '@/shared/types/zone';
import { zoneEndpoints } from '../../endpoints/admin-service/zone-endpoints';

type ZoneStore = {
    error: string | null;
    loading: boolean;
    zoneNames: ZoneNames[];
    fetchZoneNames: () => Promise<void>;
};

export const useZoneStore = create<ZoneStore>((set) => ({
    error: null,
    loading: false,
    zoneNames: [],
    fetchZoneNames: async () => {
        set({ loading: true, error: null });
        try {
            const response = await axiosInstance.get<ZoneNames[]>(zoneEndpoints.getZoneNamesAndIds);
            set({ zoneNames: response.data, loading: false });
        } catch (error: any) {
            set({ error: error.message || 'Failed to fetch zone names', loading: false });
        }
    }
}));