import { create } from "zustand";
import axiosInstance from "@/utils/axios";
import { AddPassengerToCircuit, AddPassengersToCircuitResponse } from "@/shared/types/circuit";
import { circuitEndpoints } from "../../endpoints/circuit";
import { AmendmentCircuit } from "@/shared/types/ammendment-circuit";
import { circuitAmendmentEndpoints } from "../../endpoints/amendments";
import { SearchAmendmentCircuitParams } from "@/shared/types/ammendment-circuit";
import { Pageable } from "@/shared/types/client";

type AmendmentCircuitStore = {
  loading: boolean;
  error: string | null;
  circuitAmendments: AmendmentCircuit[];
  totalElements: number;
  getAmendmentsByCircuitId: (params: SearchAmendmentCircuitParams) => Promise<void>;
};

export const useAmendmentCircuitStore = create<AmendmentCircuitStore>((set) => ({
  loading: false,
  error: null,
  circuitAmendments: [],
  totalElements: 0,
  getAmendmentsByCircuitId: async (params: SearchAmendmentCircuitParams) => {
    set({ loading: true, error: null });
    try {
      const { circuitId, ...rest } = params;
      const response = await axiosInstance.get<Pageable<AmendmentCircuit>>(
        circuitAmendmentEndpoints.amendments.getByCircuitId(circuitId.toString()),
        { params: rest }
      );
      set({ 
        loading: false, 
        circuitAmendments: response.data.content,
        totalElements: response.data.totalElements
      });
    } catch (error: any) {
      set({
        error: error.message || "Erreur lors de la récupération des usagers du circuit",
        loading: false,
      });
      throw error;
    }
  }
}));