import { create } from 'zustand';
import axiosInstance from '@/utils/axios';
import { userEndpoints } from '../../endpoints/user';

type UserStore = {
    error: string | null;
    existsUserByPersonalEmailLoading: boolean;
    existsUserByPersonalEmail: (personalEmail: string) => Promise<boolean>;
};

export const useUserStore = create<UserStore>((set) => ({
    error: null,
    existsUserByPersonalEmailLoading: false,
    existsUserByPersonalEmail: async (personalEmail: string) => {
        set({ existsUserByPersonalEmailLoading: true, error: null });
        try {
          const response = await axiosInstance.get(userEndpoints.user.existsUserByPersonalEmail(personalEmail));
          return response.data;
        } catch (error: any) {
          set({
            error: error.message || "Failed to check if user exists by personalEmail",
          });
          throw error;
        } finally {
          set({ existsUserByPersonalEmailLoading: false });
        }
      }
}));