import { create } from 'zustand';
import { vehicleEndpoints } from '../endpoints/Vehicle';
import { IVehicle } from '@/shared/types/driver';
import axiosInstance from '@/utils/axios';

type VehicleStore = {
  vehicles: IVehicle[] | null;
  loading: boolean;
  error: string | null;
  getAllVehicles: () => Promise<IVehicle[]>;
};

export const useVehicleStore = create<VehicleStore>((set, get) => ({
  vehicles: null,
  loading: false,
  error: null,

  getAllVehicles: async () => {
    set({ loading: true, error: null });
    try {
      const response = await axiosInstance.get<IVehicle[]>(vehicleEndpoints.getAll);
      const vehicles = response.data;
      set({ vehicles, loading: false });
      return vehicles;
    } catch (error: any) {
      const errorMessage = error?.response?.data?.message || error.message || 'Failed to fetch vehicles';
      set({ 
        error: errorMessage, 
        loading: false,
        vehicles: null 
      });
      return [];
    }
  },
}));