import React from 'react';
import { Dialog, DialogTitle, DialogContent,Box } from '@mui/material';
import type { ModeType, TableColumn } from '@/shared/types/common';
import ContractForm from '@/shared/sections/contract/view/contract-new-view';
import { ContractList } from '@/shared/types/contract';
import { faFileContract } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';

interface CreateContractModalProps {
  open: boolean;
  onClose: (forceClose?: boolean) => void;
  mode?: ModeType;
  tableHead?: TableColumn[];
  contrat: ContractList;
  PaperProps?: object;
}

const CreateContractModal: React.FC<CreateContractModalProps> = ({
  open,
  onClose,
  mode = 'add',
  tableHead = [],
  contrat = {} as ContractList,
  PaperProps,
}) => {
  return (
    <Dialog
      open={open}
      onClose={() => onClose(false)}
      fullWidth
      maxWidth="md"
      scroll="body"
      PaperProps={{
        sx: {
          width: '80%',
          maxHeight: '90vh',
          maxWidth: 'none',
          borderRadius: '12px',
        },
        ...PaperProps,
      }}
    >
        <DialogTitle>
  <Box sx={{ display: 'flex', alignItems: 'center', gap: 1 }}>
    <FontAwesomeIcon icon={faFileContract} />
    Créer un nouveau contrat
  </Box>
</DialogTitle>
     

      <DialogContent
        dividers={false}
        sx={{
          maxHeight: 'calc(90vh - 64px)', 
          overflowY: 'auto',            
          paddingRight: 0,
        }}
      >
        <ContractForm
          contrat={contrat}
          mode={mode}
          onClose={onClose}
          onEdit={() => { }}
          tableHead={tableHead}
          updateTabContent={() => { }}
          tabId="create-modal"
        />
      </DialogContent>
    </Dialog>
  );
};

export default CreateContractModal;
