import React from 'react';
import { Dialog, DialogTitle, DialogContent, Box } from '@mui/material';
import type { ModeType, TableColumn } from '@/shared/types/common';
import type { EstablishmentTableItem } from '@/shared/types/establishment';
import EstablishmentForm from '@/shared/sections/establishment/establishmentList/view/establishment-form-view';
import { faBuilding  } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
interface CreateEtablissementModalProps {
  open: boolean;
  onClose: (forceClose?: boolean) => void;
  mode?: ModeType;
  tableHead?: TableColumn[];
  etablissement?: EstablishmentTableItem;
  PaperProps?: object;
}

const CreateEtablissementModal: React.FC<CreateEtablissementModalProps> = ({
  open,
  onClose,
  mode = 'add',
  tableHead = [],
  etablissement = {} as EstablishmentTableItem,
  PaperProps
}) => {
  return (
   <Dialog
  open={open}
  onClose={() => onClose(false)}
  fullWidth
  maxWidth="md"
  PaperProps={{
    style: {
      width: '80%',
      maxHeight: '90vh',
      maxWidth: 'none',
    },
  }}
  scroll="paper"
>
    <DialogTitle>
  <Box sx={{ display: 'flex', alignItems: 'center', gap: 1 }}>
    <FontAwesomeIcon icon={faBuilding} />
   Créer un nouvel établissement
  </Box>
</DialogTitle>
  
  <DialogContent
    dividers
    sx={{
      overflowY: 'auto',      
      maxHeight: 'calc(90vh - 64px)',
      paddingRight: 0,       
    }}
  >
    <EstablishmentForm
      etablissement={etablissement}
      mode={mode}
      onClose={onClose}
      onSave={() => {}}
      onEdit={() => {}}
      tableHead={tableHead}
    />
  </DialogContent>
</Dialog>


  );
};

export default CreateEtablissementModal;
