"use client"

import React from 'react';
import { Dialog, DialogTitle, DialogContent, DialogProps, Box } from '@mui/material';
import TabbedForm from '@/shared/components/tabs/tabbed-form';
import type { ModeType, TableColumn } from '@/shared/types/common';
import type { AgencyList, DepartmentList, SectorList } from '@/shared/types/infrastructure';
import SectorForm from '@/shared/sections/exploitation/infrastructure/sector/view/sector-form';
import DepartmentForm from '@/shared/sections/exploitation/infrastructure/department/view/department-form';
import AgencyForm from '@/shared/sections/exploitation/infrastructure/agency/view/agency-form';
import { faNetworkWired  } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
interface TabItem {
  label: string;
  content: React.ReactNode;
  disabled?: boolean;
}

interface CreateInfrastructureModalProps extends Pick<DialogProps, 'PaperProps'> {
  open: boolean;
  onClose: (forceClose?: boolean) => void;
  mode?: ModeType;
  tableHead?: TableColumn[];
  department?: DepartmentList;
  sector?: SectorList;
  agency?: AgencyList;
}

const CreateInfrastructureModal: React.FC<CreateInfrastructureModalProps> = ({
  open,
  onClose,
  mode = 'add',
  tableHead = [],
  department = {} as DepartmentList,
  sector = {} as SectorList,
  agency = {} as AgencyList,
  PaperProps,
}) => {

  const tabs: TabItem[] = [
    {
      label: 'Secteurs',
      content: (
        <SectorForm
          sector={sector}
          mode={mode}
          onEdit={() => {}}
          onClose={onClose}
          tableHead={tableHead}
          updateTabContent={() => {}}
          tabId="sector-tab"
        />
      ),
    },
    {
      label: 'Agences',
      content:  (
        <AgencyForm
          agency={agency}
          mode={mode}
          onEdit={() => {}}
          onClose={onClose}
          tableHead={tableHead}
          updateTabContent={() => {}}
          tabId="agency-tab"
        />
      ),
    },
    {
      label: 'Départements',
      content: (
        <DepartmentForm
          department={department}
          mode={mode}
          onClose={onClose}
          onEdit={() => {}}
          tableHead={tableHead}
          updateTabContent={() => {}}
          tabId="department-tab"
        />
      ),
    },
  ];

  return (
    <Dialog
      open={open}
      onClose={() => onClose(false)}
      fullWidth
      maxWidth="md"
      scroll="body"
      PaperProps={{
        sx: {
          width: '80%',
          maxHeight: '90vh',
          maxWidth: 'none',
          overflow: 'hidden', 
          borderRadius: '12px',
        },
        ...PaperProps,
      }}
    >
     <DialogTitle>
  <Box sx={{ display: 'flex', alignItems: 'center', gap: 1 }}>
    <FontAwesomeIcon icon={faNetworkWired} />
    Créer une infrastructure
  </Box>
</DialogTitle>

      <DialogContent
        dividers={false}
        sx={{
          paddingRight: 0,
          overflow: 'hidden', 
        }}
      >
        <Box sx={{ pr: 2 }}> 
          <TabbedForm
            tabs={tabs}
            showNavigationButtons
            hasBorder
            sx={{ mt: 2 }}
          />
        </Box>
      </DialogContent>
    </Dialog>
  );
};

export default CreateInfrastructureModal;
