import FontAwesome from '@/shared/components/fontawesome';
import { CustomDateIcon } from '@/shared/components/form/form-field';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
import {
  RoadMapStyledDatePicker,
  RoadMapStyledTimePicker,
  StyledTextField,
} from '@/shared/theme/css';
import { faClock } from '@fortawesome/free-solid-svg-icons';
import { MenuItem, Typography } from '@mui/material';
import { Box, Stack } from '@mui/system';
import { FormikProps } from 'formik';
import { SendRoadMapPlanningFormValues } from '@/shared/types/roadMap';
import { useEffect } from 'react';
import dayjs, { Dayjs } from 'dayjs';
type Props = {
  formik: FormikProps<SendRoadMapPlanningFormValues>;
  planningDay: Dayjs;
};

export default function SingleDayFormPlanningSection({ formik, planningDay }: Props) {
  const { values, setFieldValue, errors, touched } = formik;
  useEffect(() => {
    setFieldValue('planningDayOption', 'specific');
    setFieldValue('planningDate', planningDay);
  }, [setFieldValue]);

  return (
    <Box
      sx={{
        mt: 2,
        p: 1.5,
        border: '1px solid',
        borderColor: 'divider',
        borderRadius: 2,
        backgroundColor: 'background.paper',
      }}
    >
      <Typography variant="subtitle2" sx={{ fontWeight: 'bold', mb: 0.5 }}>
        Planning envoyé
      </Typography>
      <Typography variant="body1">
        Jour spécifique : {dayjs(planningDay).format('DD MMMM YYYY')}
      </Typography>
    </Box>
  );
}

