import type React from 'react';
import { Box, Paper, Stack, Typography } from '@mui/material';
import FontAwesome from '@/shared/components/fontawesome';
import { faClock, faLocationDot } from '@fortawesome/free-solid-svg-icons';
import { PeriodType } from '@/shared/types/roadMap';

interface Route {
  startHour: string;
  endHour: string;
  departure: string;
  destination: string;
  periodTime: PeriodType;
}

interface JourneySummaryDriverProps {
  routes: Route[];
}
const timeBlocks = [
  { label: 'MATIN', value: 'Matin', range: '06:00–11:59' },
  { label: 'MIDI', value: 'Midi', range: '12:00–13:59' },
  { label: 'APRES_MIDI', value: 'Après-midi', range: '14:00–17:59' },
  { label: 'SOIR', value: 'Soir', range: '18:00–23:59' },
];

export const JourneySummaryDriver: React.FC<JourneySummaryDriverProps> = ({ routes }) => {
  return (
    <Box
      sx={{
        maxHeight: '200px',
        overflowY: 'auto',
        display: 'flex',
        flexDirection: 'column',
        gap: 2,
        pr: 1,
        width: '100%',
      }}
    >
      {timeBlocks.map((block) => {
        const route = routes.find((r) => r.periodTime === block.label);

        return (
          <Paper
            key={block.label}
            elevation={1}
            sx={{
              p: 2,
              borderRadius: 2,
              bgcolor: '#fdfdff',
              width: '100%',
            }}
          >
            <Stack direction="row" alignItems="center" spacing={1} mb={1}>
              <FontAwesome icon={faClock} color="primary.main" width={16} />
              <Typography variant="subtitle1" fontWeight={700} color="primary.main">
                {block.value} <Typography component="span">({block.range})</Typography>
              </Typography>
            </Stack>

            {route ? (
              <Box mt={1}>
                <Stack direction="row" spacing={1} alignItems="center" pl={4}>
                  <FontAwesome icon={faClock} color="primary.main" width={16} />
                  <Typography>
                    Départ : {route.startHour} → Arrivée : {route.endHour}
                  </Typography>
                </Stack>

                <Stack direction="row" spacing={1} alignItems="center" mt={0.5} pl={4}>
                  <FontAwesome icon={faLocationDot} color="primary.main" width={16} />
                  <Typography>De : {route.departure}</Typography>
                </Stack>

                <Stack direction="row" spacing={1} alignItems="center" mt={0.5} pl={4}>
                  <FontAwesome icon={faLocationDot} color="primary.main" width={16} />
                  <Typography>À : {route.destination}</Typography>
                </Stack>
              </Box>
            ) : (
              <Typography mt={1} fontStyle="italic" color="text.secondary" pl={4}>
                (No trajet disponible)
              </Typography>
            )}
          </Paper>
        );
      })}
    </Box>
  );
};
