export function getTripMarkerIcon(
  index: number,
  total: number,
  isPointAnEstablishment: boolean,
  departure: boolean
) {
  if (
    typeof window === 'undefined' ||
    !window.google ||
    !window.google.maps ||
    typeof window.google.maps.Size !== 'function' ||
    typeof window.google.maps.Point !== 'function'
  ) {
    return '/assets/icons/maps/dynamic/circuit-point.svg'
  }

  const url =
    index === 0
      ? departure
        ? '/assets/icons/maps/dynamic/usager-visited.svg'
        : '/assets/icons/maps/dynamic/destination-colored.svg'
      : index === total - 1
        ? !departure
          ? '/assets/icons/maps/dynamic/usager-visited.svg'
          : '/assets/icons/maps/dynamic/destination-colored.svg'
        : isPointAnEstablishment
          ? '/assets/icons/maps/dynamic/establishment.svg'
          : '/assets/icons/maps/dynamic/usager-visited.svg'

  return {
    url,
    scaledSize: new window.google.maps.Size(32, 32),
    anchor: new window.google.maps.Point(16, 32),
  }
}


