import { PeriodType, ValidatedRouteSheetDay } from '@/shared/types/roadMap';
import { TableCell, TableRow } from '@mui/material';

interface RoadMapValidationTableRowProps {
  validatedRouteSheetDayRow?: ValidatedRouteSheetDay;
  date: Date;
}
export default function RoadMapValidationTableRowFinal({
  validatedRouteSheetDayRow,
  date,
}: RoadMapValidationTableRowProps) {
  const getRouteByType = (type: PeriodType) => {
    return validatedRouteSheetDayRow && validatedRouteSheetDayRow.validatedRoads
      ? validatedRouteSheetDayRow.validatedRoads.find((route) => route.type === type) || null
      : null;
  };
  const routes = {
    morningRoute: getRouteByType(PeriodType.Matin),
    midRoute: getRouteByType(PeriodType.Midi),
    afternoonRoute: getRouteByType(PeriodType.ApresMidi),
    nightRoute: getRouteByType(PeriodType.Soir),
  };
  return (
    <TableRow>
      {/* Day Column */}
      <TableCell align="center">{date.toLocaleDateString()}</TableCell>
      {routes.morningRoute ? (
        <>
          <TableCell align="center">{`${routes.morningRoute.startHour}`}</TableCell>
          <TableCell align="center">{` ${routes.morningRoute.endHour}`}</TableCell>
        </>
      ) : (
        <>
          <TableCell align="center"> </TableCell>
          <TableCell align="center"> </TableCell>
        </>
      )}
      {routes.midRoute ? (
        <>
          <TableCell align="center">{`${routes.midRoute.startHour}`}</TableCell>
          <TableCell align="center">{` ${routes.midRoute.endHour}`}</TableCell>
        </>
      ) : (
        <>
          <TableCell align="center"> </TableCell>
          <TableCell align="center"> </TableCell>
        </>
      )}
      {routes.afternoonRoute ? (
        <>
          <TableCell align="center">{`${routes.afternoonRoute.startHour}`}</TableCell>
          <TableCell align="center">{` ${routes.afternoonRoute.endHour}`}</TableCell>
        </>
      ) : (
        <>
          <TableCell align="center"> </TableCell>
          <TableCell align="center"> </TableCell>
        </>
      )}
      {routes.nightRoute ? (
        <>
          <TableCell align="center">{`${routes.nightRoute.startHour}`}</TableCell>
          <TableCell align="center">{` ${routes.nightRoute.endHour}`}</TableCell>
        </>
      ) : (
        <>
          <TableCell align="center"> </TableCell>
          <TableCell align="center"> </TableCell>
        </>
      )}
      <TableCell align="center">{validatedRouteSheetDayRow?.totalRoadMapDaily.totalDay}</TableCell>
      <TableCell align="center">
        {validatedRouteSheetDayRow?.totalRoadMapDaily.paidHoursCentieme}
      </TableCell>
      <TableCell align="center">{validatedRouteSheetDayRow?.totalRoadMapDaily.deduction}</TableCell>
      <TableCell align="center">
        {validatedRouteSheetDayRow?.totalRoadMapDaily.paidHoursCentieme}
      </TableCell>
      <TableCell align="center">{validatedRouteSheetDayRow?.totalRoadMapDaily.delta}</TableCell>
      <TableCell align="center">{validatedRouteSheetDayRow?.totalRoadMapDaily.forfait}</TableCell>
      <TableCell align="center">
        {validatedRouteSheetDayRow?.totalRoadMapDaily.nightHours}
      </TableCell>
      <TableCell align="center">
        {validatedRouteSheetDayRow?.totalRoadMapDaily.waitingHours}
      </TableCell>
      <TableCell align="center">
        {validatedRouteSheetDayRow?.totalRoadMapDaily.numberVacations}
      </TableCell>
    </TableRow>
  );
}
