import { Fragment } from "react";

type PropsType = {
    isValid: boolean;
    defaultComponent?: React.ReactNode | JSX.Element;
    children: React.ReactNode | JSX.Element;
}
export default function InfrastructureConditionalComponent({ isValid, defaultComponent, children }: PropsType): JSX.Element {
           if (defaultComponent !== undefined && defaultComponent !== null) {
        return (
            <Fragment>
                <div style={{ display: isValid ? 'block' : 'none' }}>
                    {children}
                </div>
                <div style={{ display: isValid ? 'none' : 'block' }}>
                    {defaultComponent}
                </div>
            </Fragment>
        );
    }
    
    return (
        <Fragment>
            {isValid ? children : null}
        </Fragment>
    );
}