import * as yup from 'yup';
export const preparationUsagerSchema = yup.object().shape({
    nomComplet: yup.string().required('Champ obligatoire'),
    etablissement: yup
      .array()
      .of(yup.string().required('Établissement requis'))
      .min(1, 'Au moins un établissement requis'),
    adressEtb: yup.array().of(yup.object().shape({
        address: yup.string().required('Adresse requise'),
        lat: yup.number(),
        lng: yup.number(),
      })),
    adresse: yup.object().shape({
      address: yup.string().required('Adresse requise'),
      lat: yup.number(),
      lng: yup.number(),
    }),
    jours: yup.array().of(
      yup.object().shape({
        lundi: yup.boolean(),
        mardi: yup.boolean(),
        mercredi: yup.boolean(),
        jeudi: yup.boolean(),
        vendredi: yup.boolean(),
        samedi: yup.boolean(),
        dimanche: yup.boolean(),
      })
    ),
  });