import React from 'react';
import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import { TableColumn } from '@/shared/types/common';
import TableActionColumn from '@/shared/components/table/table-action-column';
import { ContratStyledRow, DrawerStyledRow, getStatusColor } from '@/shared/sections/contract/styles';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { IconButton } from '@mui/material';
import FontAwesome from '@/shared/components/fontawesome';
import { faPenToSquare, faTrash } from '@fortawesome/free-solid-svg-icons';
import { ActionsIconButton } from '@/shared/theme/css';
import SvgColor from '@/shared/components/svg-color';
import { IPreparationUsager } from '@/shared/types/usager';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

type Props = {
  handleEdit: (usager: IPreparationUsager) => void;
  handleDetails: (usager: IPreparationUsager) => void;
  handleCopy: (usager: IPreparationUsager) => void;
  selected: boolean;
  row: IPreparationUsager;
  dense: boolean;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
};

const TOOLTIP_TITLES = {
  edit: 'Modifier usager',
  delete: 'supprimer usager',
};

export default function PreparationUsagerTableRow({
  dense,
  row,
  handleEdit,
  handleDetails,
  handleCopy,
  selected,
  onSelectRow,
  columns,
}: Props) {
    const renderCellContent = (columnId: string, value: any) => {
      switch (columnId) {
        case 'adresse':
          return (
            row.adresse.address
          );
        default:
          return value;
      }
    };
  return (
    <DrawerStyledRow style={{ cursor: 'pointer' }}>
      {columns.map((column: TableColumn, index: number) => (
        <TableCell
          onDoubleClick={() => handleDetails(row)}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: 'nowrap',
            py: dense ? 0 : 2, px: 0,
            ...(index === 0 && {
              position: 'relative',
            }),
           }}
        >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{ position: 'absolute', top: 0, left: -4, height: '100%', color: getStatusColor(row.circuit),
              }}
            />
            </ConditionalComponent>
          {renderCellContent(column.id, row[column.id as keyof IPreparationUsager])}

        </TableCell>
      ))}

      <TableCell sx={{ px: 1, whiteSpace: 'nowrap', py: 0 }}>
        <CustomTooltip title={TOOLTIP_TITLES.edit} arrow>
          <IconButton onClick={()=> handleEdit(row)} size="small" sx={ActionsIconButton}>
            <FontAwesome icon={faPenToSquare} width={16} />
          </IconButton>
        </CustomTooltip>
        <CustomTooltip title={TOOLTIP_TITLES.delete} arrow>
          <IconButton onClick={() => void 0} size="small" sx={ActionsIconButton}>
            <FontAwesome icon={faTrash} width={16} />
          </IconButton>
        </CustomTooltip>
      </TableCell>
    </DrawerStyledRow>
  );
}
