import React from 'react';
import { Grid } from '@mui/material';
import { FormFieldType, ModeType } from '@/shared/types/common';
import { IAgent } from '@/shared/types/client';
import AgentField from './AgentField';

interface AgentStepContentProps {
  step: number;
  formik: any;
  agencyOptions: { label: string; value: string }[];
  departementOptions: { label: string; value: string }[];
  teamsOptions: { label: string; value: string }[];
  roleOptions: { label: string; value: string }[];
  permissions: { label: string; value: string }[];
  isReadOnly: boolean;
  mode: ModeType;
  handleFormFieldChange: (name: string, value: any) => void;
}

import {
  personalInfoFields,
  professionalInfoFields,
  rolePermissionFields,
  workScheduleFields,
} from '../utils/form-fields-agent';

const AgentStepContent: React.FC<AgentStepContentProps> = ({
  step,
  formik,
  agencyOptions,
  departementOptions,
  teamsOptions,
  roleOptions,
  permissions,
  isReadOnly,
  mode,
  handleFormFieldChange,
}) => {
  const fields =
    step === 0
      ? personalInfoFields
      : step === 1
        ? professionalInfoFields(agencyOptions, departementOptions, teamsOptions)
        : step === 2
          ? rolePermissionFields(roleOptions)
          : workScheduleFields;

  return (
    <Grid container spacing={3}>
      {fields.map((field: FormFieldType<IAgent>) => (
        <Grid 
          item 
          xs={12} 
          sm={field.name === 'schedule' ? 12 : 6} 
          key={String(field.name)}
        >
          <AgentField
            field={field}
            formik={formik}
            mode={mode}
            isReadOnly={isReadOnly}
            permissions={permissions}
            handleFormFieldChange={handleFormFieldChange}
          />
        </Grid>
      ))}
    </Grid>
  );
};

export default AgentStepContent;
