'use client';

import React from 'react';
import { Paper, Box, Typography, Grid, useTheme } from '@mui/material';

interface ScheduleSummaryProps {
  workingDaysCount: number;
  totalWorkingHours: number;
}

export default function ScheduleSummary({
  workingDaysCount,
  totalWorkingHours,
}: ScheduleSummaryProps) {
  const theme = useTheme();
  const average = workingDaysCount > 0 ? totalWorkingHours / workingDaysCount : 0;

  return (
    <Paper
      elevation={0}
      sx={{
        p: 2,
        mb: 3,
        backgroundColor: theme.palette.grey[50],
        borderRadius: 2,
        border: `1px solid ${theme.palette.grey[200]}`,
      }}
    >
      <Grid container spacing={2}>
        <Grid item xs={12} sm={4}>
          <Box sx={{ textAlign: 'center' }}>
            <Typography variant="h4" color="primary" fontWeight="bold">
              {workingDaysCount}
            </Typography>
            <Typography variant="body2" color="text.secondary">
              Jours travaillés
            </Typography>
          </Box>
        </Grid>
        <Grid item xs={12} sm={4}>
          <Box sx={{ textAlign: 'center' }}>
            <Typography variant="h4" color="primary" fontWeight="bold">
              {totalWorkingHours.toFixed(1)}h
            </Typography>
            <Typography variant="body2" color="text.secondary">
              Heures totales
            </Typography>
          </Box>
        </Grid>
        <Grid item xs={12} sm={4}>
          <Box sx={{ textAlign: 'center' }}>
            <Typography variant="h4" color="primary" fontWeight="bold">
              {average.toFixed(1)}h
            </Typography>
            <Typography variant="body2" color="text.secondary">
              Moyenne/jour
            </Typography>
          </Box>
        </Grid>
      </Grid>
    </Paper>
  );
}


