"use client"

import { useState } from "react"
import { Dialog, DialogTitle, DialogContent, DialogActions, Button, Typography } from "@mui/material"
import { StyledTextField } from "@/shared/theme/css"

interface PermissionDialogProps {
  open: boolean
  onClose: () => void
  onAdd: (permission: string) => void
}

export default function PermissionDialog({ open, onClose, onAdd }: PermissionDialogProps) {
  const [newPermission, setNewPermission] = useState("")

  const handleAddCustomPermission = () => {
    if (newPermission.trim() !== "") {
      onAdd(newPermission.trim())
      setNewPermission("")
    }
  }

  const handleClose = () => {
    setNewPermission("")
    onClose()
  }

  return (
    <Dialog
      open={open}
      onClose={handleClose}
      sx={{
        "& .MuiDialog-paper": {
          borderRadius: 2,
        },
      }}
    >
      <DialogTitle
        sx={{
          color: "primary.main",
        }}
      >
        <Typography variant="h6" fontWeight={400}>
          Ajouter une nouvelle permission
        </Typography>
      </DialogTitle>
      <DialogContent sx={{ py: 2, px: 2 }}>
        <StyledTextField
          autoFocus
          margin="dense"
          label="Nom de la permission"
          fullWidth
          variant="outlined"
          value={newPermission}
          onChange={(e) => setNewPermission(e.target.value)}
          onKeyPress={(e) => {
            if (e.key === "Enter") {
              handleAddCustomPermission()
            }
          }}
        />
      </DialogContent>
      <DialogActions sx={{ py: 2, px: 3, justifyContent: "space-between" }}>
        <Button
          onClick={handleClose}
          sx={{
            color: "#8270C4",
            "&:hover": {
              backgroundColor: "rgba(130, 112, 196, 0.08)",
            },
          }}
        >
          Annuler
        </Button>
        <Button
          onClick={handleAddCustomPermission}
          sx={{
            backgroundColor: "#8270C4",
            color: "white",
            "&:hover": { backgroundColor: "#6951BC" },
            px: 3,
            py: 1,
            borderRadius: 2,
          }}
        >
          Ajouter
        </Button>
      </DialogActions>
    </Dialog>
  )
}
