import { FormFieldType } from '@/shared/types/common';
import { IForgotPasswordForm } from '@/shared/types/password';

export type ResetStep = 'email' | 'code' | 'newPassword' | 'success';

interface StepConfig {
  title: string;
  subtitle: string;
  buttonText: string;
  fields: FormFieldType<IForgotPasswordForm>[];
}

export const STEP_CONFIG: Record<ResetStep, StepConfig> = {
  email: {
    title: 'Mot de passe oublié',
    subtitle: 'Entrez votre adresse email pour recevoir un code',
    buttonText: 'Envoyer le code',
    fields: [],  
  },
  code: {
    title: 'Vérification du code',
    subtitle: 'Entrez le code reçu par email',
    buttonText: 'Vérifier le code',
    fields: [], 
  },
  newPassword: {
    title: 'Nouveau mot de passe',
    subtitle: 'Définissez votre nouveau mot de passe',
    buttonText: 'Réinitialiser le mot de passe',
    fields: [], 
  },
  success: {
    title: 'Mot de passe réinitialisé !',
    subtitle: 'Votre mot de passe a été réinitialisé avec succès',
    buttonText: 'Retour à la connexion',
    fields: [],
  },
};

export const TIMER_DURATION = 0; 

export const VALIDATION_MESSAGES = {
  email: {
    required: 'Email requis',
    invalid: 'Email doit être une adresse email valide',
  },
  code: {
    required: 'Code de confirmation requis',
    length: 'Le code doit contenir 6 caractères',
  },
  password: {
    required: 'Mot de passe requis',
    minLength: 'Le mot de passe doit contenir au moins 8 caractères',
    lowercase: 'Le mot de passe doit contenir au moins une lettre minuscule',
    uppercase: 'Le mot de passe doit contenir au moins une lettre majuscule',
    number: 'Le mot de passe doit contenir au moins un chiffre',
    special: 'Le mot de passe doit contenir au moins un caractère spécial (@#$&!)',
    match: 'Les mots de passe doivent correspondre',
  },
};

export const SUCCESS_MESSAGES = {
  codeSent: 'Code de confirmation envoyé à votre email',
  codeVerified: 'Code vérifié avec succès',
  codeResent: 'Code renvoyé à votre email',
  passwordReset: 'Mot de passe réinitialisé avec succès',
};

export const ERROR_MESSAGES = {
  default: 'Une erreur est survenue',
  resendCode: 'Erreur lors du renvoi du code',
  passwordReset: 'Erreur lors de la réinitialisation du mot de passe',
};

export const PASSWORD_REQUIREMENTS = {
  minLength: 8,
  patterns: {
    lowercase: /[a-z]/,
    uppercase: /[A-Z]/,
    number: /[0-9]/,
    special: /[@#$&!]/,
  },
};

export const FORM_LABELS = {
  email: 'Adresse email',
  code: 'Code de confirmation',
  newPassword: 'Nouveau mot de passe',
  confirmPassword: 'Confirmez le mot de passe',
};

export const PLACEHOLDERS = {
  email: 'Entrez votre adresse email',
  code: 'Entrez le code reçu par email',
  newPassword: 'Entrez votre nouveau mot de passe',
  confirmPassword: 'Confirmez votre nouveau mot de passe',
};

export const BUTTON_TEXTS = {
  resendCode: 'Renvoyer le code',
  resendCodeTimer: (time: string) => `Renvoyer (${time})`,
  backToLogin: 'Retour à la connexion',
};

export const INFO_MESSAGES = {
  emailSent: 'Code envoyé à :',
  checkSpam: '💡 Vérifiez aussi votre dossier spam/courrier indésirable',
  rememberPassword: 'Vous vous souvenez de votre mot de passe ?',
  passwordResetSent: 'Un lien de réinitialisation a été envoyé à :',
};