// src/shared/sections/auth/utils/forgot-password-form-fields.ts
import { FormFieldType } from '@/shared/types/common';
import { IForgotPasswordForm } from '@/shared/types/password';



export const ForgotPasswordFormData: Record<string, FormFieldType<IForgotPasswordForm>[]> = {
  email: [
    {
      name: 'email',
      label: 'Adresse email',
      type: 'text',
      placeholder: 'Entrez votre adresse email',
      required: true,
    },
  ],
  code: [
    {
      name: 'code',
      label: 'Code de confirmation',
      type: 'text',
      placeholder: 'Entrez le code reçu par email',
      required: true,
    },
  ],
  newPassword: [
    {
      name: 'newPassword',
      label: 'Nouveau mot de passe',
      type: 'password',
      placeholder: 'Entrez votre nouveau mot de passe',
      required: true,
      showPassword: true,
    },
    {
      name: 'confirmPassword',
      label: 'Confirmez le mot de passe',
      type: 'password',
      placeholder: 'Confirmez votre nouveau mot de passe',
      required: true,
      showPassword: true,
    },
  ],
};