import * as Yup from 'yup';
import { VALIDATION_MESSAGES } from './constants';

export const validationSchemas = {
  email: Yup.object().shape({
    email: Yup.string()
      .required(VALIDATION_MESSAGES.email.required)
      .email(VALIDATION_MESSAGES.email.invalid),
  }),
  code: Yup.object().shape({
    code: Yup.string()
      .required(VALIDATION_MESSAGES.code.required)
      .min(6, VALIDATION_MESSAGES.code.length),
  }),
  newPassword: Yup.object().shape({
    newPassword: Yup.string()
      .required(VALIDATION_MESSAGES.password.required)
      .min(8, VALIDATION_MESSAGES.password.minLength)
      .matches(/[a-z]/, VALIDATION_MESSAGES.password.lowercase)
      .matches(/[A-Z]/, VALIDATION_MESSAGES.password.uppercase)
      .matches(/[0-9]/, VALIDATION_MESSAGES.password.number)
      .matches(/[@#$&!]/, VALIDATION_MESSAGES.password.special),
    confirmPassword: Yup.string()
      .required(VALIDATION_MESSAGES.password.required)
      .oneOf([Yup.ref('newPassword')], VALIDATION_MESSAGES.password.match),
  }),
};