import { AmendmentCircuit } from '@/shared/types/ammendment-circuit';
import { TabConfig, useTabsManager } from '../../../../hooks/use-tabs-manager';
import { INITIAL_AVENANT_DATA } from '@/shared/_mock/_avenants';


const avenantConfig: TabConfig<AmendmentCircuit> = {
  type: 'avenant',
  listTitle: 'Liste des avenants',
  newItemTitle: 'Nouveau avenant',
  initialData: INITIAL_AVENANT_DATA,
  getItemCode: (avenant) => avenant.title,
};

export function useAvenantTabs() {
  return useTabsManager<AmendmentCircuit>(avenantConfig);
}

