import { IDriverAbsence } from '@/shared/types/driver-absence';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_ABSENCE_DRIVER_DATA } from '@/shared/_mock/_absenceDriver';
export function useAbsenceDriverTabs(isNonTraite : boolean) {
  const absenceDriverConfig: TabConfig<IDriverAbsence> = {
    type: 'absence',
    listTitle: 'Liste absence',
    newItemTitle: 'Nouvelle absence',
    initialData: INITIAL_ABSENCE_DRIVER_DATA(isNonTraite),
    getItemCode: (absence) => absence.driverName,
  };
  return useTabsManager<IDriverAbsence>(absenceDriverConfig);
}

