import * as Yup from 'yup';

export const driverAbsenceValidationSchema = Yup.object().shape({
  dateDebut: Yup.date()
    .typeError('La date de début est invalide')
    .required('La date de début est requise')
    .max(Yup.ref('dateFin'), 'La date de début doit être antérieure ou égale à la date de fin'),
  dateFin: Yup.date()
    .typeError('La date de fin est invalide')
    .required('La date de fin est requise')
    .min(Yup.ref('dateDebut'), 'La date de fin doit être postérieure ou égale à la date de début'),
  justificatif: Yup.mixed().nullable(),
  statut: Yup.string().nullable(),
  validePar: Yup.string().nullable(),
  chauffeurAffecte: Yup.string().required('Le chauffeur affecté à un trajet est requis'),
  chauffeur: Yup.string().required('Le chauffeur est requis'),
  typeAbsence: Yup.string().required('Le type d\'absence est requis'),
  modeReception: Yup.string().required('Le mode de réception est requis'),
  nombreHeures: Yup.string().required('Le nombre d\'heures est requis'),
});