import { useVehicleStore } from "@/shared/api/stores/vehicleStore";
import { IVehicle } from "@/shared/types/driver";
import { useEffect, useState } from "react";

export function useDriverForm() {
  const [vehicleOptions, setVehicleOptions] = useState<IVehicle[]>([]);
  const { vehicles, getAllVehicles } = useVehicleStore();


  useEffect(() => {
    const fetchVehicles = async () => {
      await getAllVehicles();
    };
    fetchVehicles();
  }, []);

  useEffect(() => {
    if (vehicles) {
      setVehicleOptions(vehicles);
    }
  }, [vehicles]);

  return { vehicleOptions };
}