import { useState, useCallback } from 'react'
import { tripsApi } from '@/shared/api/endpoints/hr/trips'
import type { TripShortDTO } from '@/shared/types/trip'

export function useTrips() {
  const [trips, setTrips] = useState<TripShortDTO[]>([])
  const [loading, setLoading] = useState(false)
  const [error, setError] = useState<string | null>(null)

  const fetchTrips = useCallback(async (driverId: number) => {
    if (!driverId || !Number.isFinite(Number(driverId))) {
      setTrips([])
      return
    }

    setLoading(true)
    setError(null)

    try {
      const response = await tripsApi.getShortTripsByDriver(driverId)
      setTrips(response.data || [])
    } catch (err) {
      setError('Erreur lors du chargement des trajets')
      setTrips([])
    } finally {
      setLoading(false)
    }
  }, [])

  return {
    trips,
    loading,
    error,
    fetchTrips
  }
}
