import * as yup from 'yup';

export const driverSchema = yup.object().shape({
  civility: yup.string().required('La civilité est requise'),
  lastName: yup.string().required('Le nom est requis'),
  firstName: yup.string().required('Le prénom est requis'),
  birthDate: yup.date().required('La date de naissance est requise'),
  phoneNumber: yup.string()
    .matches(/^[0-9]{10}$/, 'Numéro de téléphone invalide')
    .required('Le téléphone est requis'),
  email: yup.string().email('Email invalide').required('Email requis'),

});
