import { ITrajet } from "@/shared/types/trajet"
import { StatusColor } from "./utils/schedule-utils"
import { TripCircuitDetails } from "@/shared/types/circuit"
import { DriverAbsenceType } from "@/shared/api/stores/driverAbsenceStore"
import { IActivePlanningDriver } from "@/shared/types/driver"

export interface Driver {
  id: string
  name: string
  company: string
  vehicleId: string
  immatricule: string
  phoneNumber: string
}
export interface DriverPlanning {
  id : string 
  name : string 
  departmentId: string 
  departmentName : string 
}

export interface DriverTimeSlot {
  id: string
  driverId: string
  codeCircuit: string
  nameCircuit?: string
  name: string
  vehicleId: string
  isAssigned: boolean,
  startHeure: string,
  startMinute: string,
  endHeure: string,
  endMinute: string,
  pickupStartHeure: string,
  pickupStartMinute: string,
  returnEndHeure: string,
  nbPassengers: number,
  returnEndMinute: string,
  date: string
  color: StatusColor
  trajet: string
}

export interface ScheduleData {
  drivers: Driver[]
  timeSlots: DriverTimeSlot[]
  absences?: DriverAbsence[]
}

export interface DriverAbsence {
  id: string
  driverId: string
  startDate: string
  endDate: string
  startHeure: string
  startMinute: string
  endHeure: string
  endMinute: string
  type: DriverAbsenceType
  justification: boolean
  reason?: string
}

export interface DraggableTimeSlotProps {
  slot: DriverTimeSlot
  width: number
  top: number
  left?: number
  height: string | number
  handlePopoverOpenT: (event: React.MouseEvent<HTMLElement>, slot: DriverTimeSlot) => void
  handlePopoverCloseT: () => void
  onDoubleClick: (slot: DriverTimeSlot) => void
  onCopySlot?: (slot: DriverTimeSlot) => void;
  onDisaffectSlot: (driverId: string, slotId: string) => void;
  cellWidth: number;
  colorDegree?: number;
  setOpenRoadmapDialog: React.Dispatch<React.SetStateAction<boolean>>
  setPlanningDriver : React.Dispatch<React.SetStateAction<IActivePlanningDriver>>
  driver : DriverPlanning ; 
}

export interface DriverDetail {
  icon: any;
  label: string;
  value: string;
}

export interface DurationFilter {
  enabled: boolean
  startHour: string
  startMinute: string
  endHour: string
  endMinute: string
}