import { _BINARY_Qst, _OPTION_VEHICULE, _TRAJET_ETAT, _TRAJET_TYPE } from '@/shared/_mock/_trajets';
import { FormFieldType } from '@/shared/types/common';
import { IAddPoint, ITrajet } from '@/shared/types/trajet';
import { _SENS_AR, ETS_NAMES } from '@/shared/_mock';

import {
  faTag,
  faStickyNote,
  faUserTie,
} from '@fortawesome/free-solid-svg-icons';
import { sensTripOptions, TripCircuitDetails, tripStateOptions, tripTypeOptions } from '@/shared/types/circuit';
import { _Boolean_Options } from '@/shared/sections/usager/utils/form-fields-representative';
import { Option } from '@/shared/sections/circuit/utils/form-fields-circuit';
import { Driver } from '../../types';


export const getPlanningTrajetFormFields = (drivers?: Driver[]): FormFieldType<TripCircuitDetails>[] => {
  const driverOptions = drivers?.map(driver => ({
    label: `${driver.name}`.trim(),
    value: driver.id || `${driver.name}`
  })) || [];

  return [
    {
      name: 'tripTitled',
      label: 'Intitulé du trajet',
      type: 'text',
      icon: faTag,
      required: true,
    },
    {
      name: 'circuitTitled',
      label: 'Circuit, Avenant',
      type: 'text',
      placeholder: 'Entrez une valeur',
      required: true,
      icon: '/assets/icons/menu/ic_exploitation.svg',
    },
    {
      name: 'lastAmendmentDate',
      label: 'Date de l\'avenant',
      type: 'date',
    },
    {
      name: 'tripState',
      label: 'Etat',
      type: 'select',
      options: tripStateOptions,
    },
    {
      name: 'tripType',
      label: 'Type',
      type: 'select',
      options: tripTypeOptions,
    },
    {
      name: 'customizedDate',
      label: 'Date de personnalisation ',
      type: 'date',
    },
    {
      name: 'hasTolls',
      label: 'Péages inclus',
      type: 'checkbox',
      options: _Boolean_Options,
    },
    {
      name: 'sens',
      label: 'Trajet',
      type: 'checkbox',
      options: sensTripOptions,
    },
    {
      name: 'weeklySchedules',
      label: "Jours",
      placeholder: 'Entrez un nom',
      type: 'select',
      options: [
        { value: 'lundi', label: 'Lundi' },
        { value: 'mardi', label: 'Mardi' },
      ]
    },
    {
      name: 'rotation',
      label: 'Rotation',
      type: 'checkbox',
      options: _Boolean_Options,
    },
    {
      name: 'tripObservation',
      label: 'Observation / Objet de le personnalisation',
      placeholder: 'Ajoutez une note ou une observation',
      type: 'textarea',
      icon: faStickyNote,
      required: true,
    },
    {
      name: 'routeSheetNote',
      label: 'Observation feuille de route',
      placeholder: 'Ajoutez une note ou une observation',
      type: 'textarea',
      icon: faStickyNote,
    },
    {
      name: 'driver',
      label: 'Chauffeur',
      type: 'select',
      icon: faUserTie,
      placeholder: 'select un chauffeur',
      required: true,
      options: driverOptions,
    },
  ];
};


export const ETS_OPTIONS = Object.values(ETS_NAMES).map((ets) => ({
  label: ets,
  value: ets,
}));

export const getAddPointFormFields = (
  establishmentOptions: Option[],
  searchEstablishments: (query?: string) => void,
  passengersOptions: Option[],
  searchPassengersWithNoCircuit: (query?: string) => void
): FormFieldType<IAddPoint>[] => [

    {
      name: "titleEndPoint",
      label: "Intitulé End Point",
      type: "text",
      icon: faTag,
      placeholder: 'Entrez un texte',
    },
    {
      name: "endPointAddress",
      label: "Adresse End Point",
      type: "address",
      placeholder: 'Adresse, code postal, ville',
    },
    {
      name: "passengerId",
      label: "Usager",
      type: "combobox",
      required: true,
      options: passengersOptions,
      onSearch: searchPassengersWithNoCircuit,
    },
    {
      name: "establishmentId",
      label: "Établissement",
      type: "combobox",
      options: establishmentOptions,
      onSearch: searchEstablishments,
    },
  ]
