import { addMinutes } from "date-fns"
import type { DriverTimeSlot, DriverAbsence } from "../types"
import { TimeSlot } from "@/shared/sections/planning/types/planning-types"

export const INTERVAL_MINUTES = 15
export const calculateTimeSlotWidth = (
  startHeure: string,
  startMinute: string,
  endHeure: string,
  endMinute: string,
  intervalMinutes: number,
  cellWidth: number,
) => {
  const startTotal = Number.parseInt(startHeure) * 60 + Number.parseInt(startMinute)
  const endTotal = Number.parseInt(endHeure) * 60 + Number.parseInt(endMinute)
  const duration = endTotal - startTotal
  return (duration / intervalMinutes) * cellWidth
}

export const isTimeSlotInCell = (slot: DriverTimeSlot | TimeSlot | DriverAbsence, cellHour: string, cellMinute: string) => {
  // if ("pickupStartHeure" in slot) {
  //   return slot.pickupStartHeure === cellHour && slot.pickupStartMinute === cellMinute
  // }
  return slot.startHeure === cellHour && slot.startMinute === cellMinute
}
export const groupOverlappingSlots = (slots: (DriverTimeSlot | TimeSlot | DriverAbsence)[]) => {
  if (slots.length === 0) return []

  const sortedSlots = [...slots].sort((a, b) => {
    const aStart = Number.parseInt(a.startHeure) * 60 + Number.parseInt(a.startMinute)
    const bStart = Number.parseInt(b.startHeure) * 60 + Number.parseInt(b.startMinute)
    return aStart - bStart
  })

  const groups: (DriverTimeSlot | TimeSlot | DriverAbsence)[][] = []
  let currentGroup: (DriverTimeSlot | TimeSlot | DriverAbsence)[] = [sortedSlots[0]]
  let currentEnd = Number.parseInt(sortedSlots[0].endHeure) * 60 + Number.parseInt(sortedSlots[0].endMinute)

  for (let i = 1; i < sortedSlots.length; i++) {
    const slot = sortedSlots[i]
    const slotStart = Number.parseInt(slot.startHeure) * 60 + Number.parseInt(slot.startMinute)
    const slotEnd = Number.parseInt(slot.endHeure) * 60 + Number.parseInt(slot.endMinute)

    if (slotStart < currentEnd) {
      currentGroup.push(slot)
      currentEnd = Math.max(currentEnd, slotEnd)
    } else {
      groups.push(currentGroup)
      currentGroup = [slot]
      currentEnd = slotEnd
    }
  }

  groups.push(currentGroup)
  return groups
}

export const findSlotIndexInGroup = (
  slot: DriverTimeSlot | TimeSlot | DriverAbsence, 
  overlappingGroups: (DriverTimeSlot | TimeSlot | DriverAbsence)[][]
) => {
  for (const group of overlappingGroups) {
    const index = group.findIndex(s => s.id === slot.id);
    if (index !== -1) return index
  }
  return 0;
}

export const getHourIntervals = (selectedDate: Date) => {
  const intervals = []
  let currentTime = new Date(selectedDate)
  currentTime.setHours(0, 0, 0)

  for (let i = 0; i < 24; i++) {
    intervals.push({
      hour: currentTime.getHours().toString().padStart(2, "0"),
      startCell: i * 4,
      endCell: (i + 1) * 4 - 1,
    })
    currentTime = addMinutes(currentTime, 60)
  }
  return intervals
}

export enum StatusColor  {
  ERROR = "#FF3434",
  SUCCESS = "#30BA1D",
  WARNING = "#F9B90B",
  INFO = "#5176FE",
  PRIMARY = "#746CD4",
  GREY = "#919EAB",
}

export const getBgColor = (color: StatusColor) => {
  switch (color) {
    case StatusColor.ERROR:
      return "#FFEBEB";
    case StatusColor.SUCCESS:
      return "#EAF8E8";
    case StatusColor.WARNING:
      return "#FEF8E7";
    case StatusColor.INFO:
      return "#EEF1FF";
    case StatusColor.GREY:
      return "#DFE3E8";
    case StatusColor.PRIMARY:
      return 'primary.lighter';
    default:
      return 'primary.lighter';
  }
};


