'use client';

import React, { useState } from 'react';
import TableManager from '@/shared/components/table/table-manager';
import AddNewRoaMapTableRow from './add-new-roadmap-table-row';
import { PlanningRequest } from '@/shared/types/roadMap';
interface AddNewRoadMapTableProps {
  table: any;
  filteredData: PlanningRequest[];
  filters: any;
  tableHead: any[];
  notFound: boolean;
  dataToExport: any;
  activeTab: string;
  totalElements?: number;
  onFilterChange: (key: string, value: string, condition: string) => void;
  onResetFilters: () => void;
  onResetColumns: () => void;
  onColumnsChange: (columns: any[]) => void;
  handleEdit: (row: PlanningRequest) => void;
  handleCopy: (row: PlanningRequest) => void;
  handleView: (row: PlanningRequest) => void;
}

export default function AddNewRoadMapTable({
  table,
  filteredData,
  filters,
  tableHead,
  notFound,
  dataToExport,
  activeTab,
  totalElements,
  onFilterChange,
  onResetFilters,
  onResetColumns,
  onColumnsChange,
  handleEdit,
  handleCopy,
  handleView,
}: AddNewRoadMapTableProps) {
  const [selectedRow, setSelectedRow] = useState<any | null>(null);

  const renderRow = (row: PlanningRequest) => (
    <AddNewRoaMapTableRow
      key={row.id}
      dense={table.dense}
      row={row}
      handleCopy={handleCopy}
      handleEdit={handleEdit}
      handleDetails={handleView}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead}
    />
  );

  return (
    <>
      <TableManager
        filteredData={filteredData}
        table={table}
        tableHead={tableHead}
        notFound={notFound}
        filters={filters}
        onFilterChange={onFilterChange}
        renderRow={renderRow}
        count={totalElements}
      />
    </>
  );
}
