import { Stack } from '@mui/material';
import { RoadMapStyledDatePicker, RoadMapStyledTimePicker } from '@/shared/theme/css';
import FontAwesome from '@/shared/components/fontawesome';
import { faClock } from '@fortawesome/free-solid-svg-icons';
import { CustomDateIcon } from '@/shared/components/form/form-field';
import { FormikProps } from 'formik';
import { SendRoadMapPlanningFormValues } from '@/shared/types/roadMap';
type Props = {
  formik: FormikProps<SendRoadMapPlanningFormValues>;
};

export default function DailyFormSection({ formik }: Props) {
  const { values, setFieldValue, errors, touched } = formik;
  return (
    <>
      <Stack direction="row" spacing={2}>
        <RoadMapStyledDatePicker
          value={formik.values.sendDate}
          onChange={(val) => formik.setFieldValue('sendDate', val)}
          views={['year', 'month', 'day']}
          slots={{ openPickerIcon: CustomDateIcon }}
          slotProps={{
            textField: {
              placeholder: 'Démarrage le',
              InputLabelProps: { shrink: true },
              fullWidth: true,
              error: !!(touched.sendDate && errors.sendDate),
              helperText: touched.sendDate && errors.sendDate,
            },
          }}
          sx={{ width: '100%' }}
        />
        <RoadMapStyledTimePicker
          value={formik.values.sendHour}
          onChange={(val) => formik.setFieldValue('sendHour', val)}
          label="Heure d'envoi"
          format="HH:mm"
          views={['hours', 'minutes']}
          slots={{
            openPickerIcon: () => <FontAwesome icon={faClock} sx={{ color: 'primary.main' }} />,
          }}
          slotProps={{
            textField: {
              placeholder: "Sélectionner l'heure",
              fullWidth: true,
              error: !!(touched.sendHour && errors.sendHour),
              helperText: touched.sendHour && errors.sendHour,
            },
          }}
        />
      </Stack>
      <Stack direction="row" spacing={2} mt={2}>
        <RoadMapStyledDatePicker
          value={formik.values.startDate}
          onChange={(val) => formik.setFieldValue('startDate', val)}
          views={['year', 'month', 'day']}
          slots={{ openPickerIcon: CustomDateIcon }}
          slotProps={{
            textField: {
              placeholder: 'Période du',
              InputLabelProps: { shrink: true },
              fullWidth: true,
              error: !!(touched.startDate && errors.startDate),
              helperText: touched.startDate && errors.startDate,
            },
          }}
          sx={{ width: '100%' }}
        />
        <RoadMapStyledDatePicker
          value={formik.values.endDate}
          onChange={(val) => formik.setFieldValue('endDate', val)}
          views={['year', 'month', 'day']}
          slots={{ openPickerIcon: CustomDateIcon }}
          slotProps={{
            textField: {
              placeholder: 'Au',
              InputLabelProps: { shrink: true },
              fullWidth: true,
              error: !!(touched.endDate && errors.endDate),
              helperText: touched.endDate && errors.endDate,
            },
          }}
          sx={{ width: '100%' }}
        />
      </Stack>
    </>
  );
}
