import FontAwesome from '@/shared/components/fontawesome';
import { CustomDateIcon } from '@/shared/components/form/form-field';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
import {
  RoadMapStyledDatePicker,
  RoadMapStyledTimePicker,
  StyledTextField,
} from '@/shared/theme/css';
import { faClock } from '@fortawesome/free-solid-svg-icons';
import { MenuItem } from '@mui/material';
import { Stack } from '@mui/system';
import { FormikProps } from 'formik';
import { SendRoadMapPlanningFormValues } from '@/shared/types/roadMap';
type Props = {
  formik: FormikProps<SendRoadMapPlanningFormValues>;
};

export default function SingleDayFormSection({ formik }: Props) {
  const { values, setFieldValue, errors, touched } = formik;

  return (
    <>
      <Stack direction="row" spacing={2}>
        <RoadMapStyledDatePicker
          value={values.startDate}
          onChange={(val) => setFieldValue('startDate', val)}
          views={['year', 'month', 'day']}
          slots={{ openPickerIcon: CustomDateIcon }}
          slotProps={{
            textField: {
              placeholder: "Date d'envoi",
              InputLabelProps: { shrink: true },
              fullWidth: true,
              error: !!(touched.startDate && errors.startDate),
              helperText: touched.startDate && errors.startDate,
            },
          }}
          sx={{ width: '100%' }}
        />

        <RoadMapStyledTimePicker
          value={values.sendHour}
          onChange={(val) => setFieldValue('sendHour', val)}
          label="Heure d'envoi"
          format="HH:mm"
          views={['hours', 'minutes']}
          slots={{
            openPickerIcon: () => <FontAwesome icon={faClock} sx={{ color: 'primary.main' }} />,
          }}
          slotProps={{
            textField: {
              placeholder: "Sélectionner l'heure",
              fullWidth: true,
              error: !!(touched.sendHour && errors.sendHour),
              helperText: touched.sendHour && errors.sendHour,
            },
          }}
        />
      </Stack>

      <StyledTextField
        select
        fullWidth
        label="Planning de quel jour ?"
        value={values.planningDayOption}
        onChange={(e) => setFieldValue('planningDayOption', e.target.value)}
        error={!!(touched.planningDayOption && errors.planningDayOption)}
        helperText={touched.planningDayOption && errors.planningDayOption}
      >
        <MenuItem value="same">Même jour</MenuItem>
        <MenuItem value="next">Jour suivant</MenuItem>
        <MenuItem value="specific">Jour spécifique</MenuItem>
      </StyledTextField>

      <ConditionalComponent isValid={values.planningDayOption === 'specific'}>
        <RoadMapStyledDatePicker
          value={values.planningDate}
          onChange={(val) => setFieldValue('planningDate', val)}
          views={['year', 'month', 'day']}
          slots={{ openPickerIcon: CustomDateIcon }}
          slotProps={{
            textField: {
              placeholder: 'Date de planning',
              InputLabelProps: { shrink: true },
              fullWidth: true,
              error: !!(touched.planningDate && errors.planningDate),
              helperText: touched.planningDate && errors.planningDate,
            },
          }}
          sx={{ width: '100%' }}
        />
      </ConditionalComponent>
    </>
  );
}
