'use client';

import CustomDrawer from '@/shared/components/drawer/custom-drawer';
import RoadMapHistoryTable from '../../roadmap-list/add-roadmap/roadmap-history-table';

const DRAWER_WIDTH = 550;

type Props = {
  isOpen: any;
  onClose: () => void;
  driverId: number;
  date: string;
};

export default function RoadMapDrawer({ isOpen, onClose, driverId, date }: Props) {
  return (
    <CustomDrawer drawerWidth={DRAWER_WIDTH} open={isOpen.value} onClose={onClose}>
      <RoadMapHistoryTable  driverId={driverId} date={date} />
    </CustomDrawer>
  );
}
