'use client';

import React from 'react';
import { Box, Table, TableBody, TableCell, TableHead } from '@mui/material';
import { TableConfig } from '@/hooks/use-table-manager';
import { BaseStyledRow, TrajetStyledRow } from '@/shared/sections/contract/styles';
import { IValidRoadmap } from '@/shared/types/driver';
import { _validRoadmapData, DEFAULT_VALID_ROADMAP_TABLE_HEAD } from '@/shared/_mock/_validRoadmap';
import { StyledTableContainer } from '@/shared/theme/css';
import { HeaderCellWidthColor, StyledTableRow } from '@/shared/components/form/style';

export default function DriverStatsTable() {
  const tableHead = DEFAULT_VALID_ROADMAP_TABLE_HEAD;

  const renderRow = (row: IValidRoadmap) => {
    return (
      <TrajetStyledRow key={row.id}>
        {tableHead.map((column: any) => (
          <TableCell
            key={column.id}
            align={column.align || 'left'}
            sx={{ whiteSpace: 'nowrap', py: 1 }}
          >
            {row[column.id as keyof IValidRoadmap]}
          </TableCell>
        ))}
      </TrajetStyledRow>
    );
  };

  return (
    <Box sx={{ mt: 3 }}>
      <StyledTableContainer>
        <Table>
          <TableHead>
            <BaseStyledRow>
              {tableHead.map((headCell) => (
                <HeaderCellWidthColor key={headCell.id}>{headCell.label}</HeaderCellWidthColor>
              ))}
            </BaseStyledRow>
          </TableHead>
          <TableBody>
            {renderRow(_validRoadmapData[0])}
          </TableBody>
        </Table>
      </StyledTableContainer>
    </Box>
  );
}
