import { DEFAULT_TOTAL_HOUR_RESULT_HEAD } from '@/shared/_mock/_validRoadmap';
import { HeaderCellWidthColor } from '@/shared/components/form/style';
import { BaseStyledRow, TrajetStyledRow } from '@/shared/sections/contract/styles';
import { StyledTableContainer } from '@/shared/theme/css';
import { ITotalHourResult } from '@/shared/types/roadMap';
import { Box, Table, TableBody, TableCell, TableHead, TableRow } from '@mui/material';

interface TotalHourResultProps {
  data?: ITotalHourResult | null;
}
const FIELDS_ORDER: (keyof ITotalHourResult)[] = [
  'totalDay',
  'totalCentieme',
  'deduction',
  'paidHoursCentieme',
  'delta',
  'forfait',
  'nightHours',
  'waitingHours',
  'numberVacations',
];

const DEFAULTS: Record<keyof ITotalHourResult, string> = {
  id: '',
  totalDay: '00:00',
  totalCentieme: '00,00',
  deduction: '00:00',
  paidHoursCentieme: '00,00',
  delta: '00:00',
  forfait: '00:00',
  nightHours: '0,00',
  waitingHours: '0,00',
  numberVacations: '0',
};
export default function TotalHourResult({ data }: TotalHourResultProps) {
  const tableHead = DEFAULT_TOTAL_HOUR_RESULT_HEAD;

  return (
    <Box sx={{ mt: 3 }}>
      <StyledTableContainer>
        <Table>
          <TableHead>
            <BaseStyledRow>
              {tableHead.map((headCell) => (
                <HeaderCellWidthColor key={headCell.id}>{headCell.label}</HeaderCellWidthColor>
              ))}
            </BaseStyledRow>
          </TableHead>
          <TableBody>
            <TableRow>
              {FIELDS_ORDER.map((key) => (
                <TableCell key={key} align="center">
                  {data?.[key] ?? DEFAULTS[key]}
                </TableCell>
              ))}
            </TableRow>
          </TableBody>
        </Table>
      </StyledTableContainer>
    </Box>
  );
}
