'use client';

import ScheduleVerificationTable from '@/shared/components/roadmap/schedule-verification-table';
import {
  _driverScheduleList,
  _geolocationList,
  DEFAULT_DRIVER_SCHEDULE_TABLE_HEAD,
  DEFAULT_GEOLOCATION_TABLE_HEAD,
} from '@/shared/_mock/_roadMap';
import WeeklyVerificationPanel, {
  VerificationTableType,
} from '@/shared/components/roadmap/weekly-verification-panel';
import { useEffect, useState } from 'react';
import { useRoadMapStore } from '@/shared/api/stores/roadMapStore';
import { ICombinedTable, IDriverRoadmap } from '@/shared/types/roadMap';

function transformCombinedTable(combinedTable: ICombinedTable): {
  id: string;
  date: string;
  matin: string;
  midi: string;
  apresMidi: string;
  soir: string;
}[] {
  return combinedTable.combinedTableDayList.map((day) => {
    const slotMap: Record<string, string> = {
      MATIN: 'matin',
      MIDI: 'midi',
      APRES_MIDI: 'apresMidi',
      SOIR: 'soir',
    };

    const row: any = {
      id: day.id.toString(),
      date: day.date,
      matin: '—',
      midi: '—',
      apresMidi: '—',
      soir: '—',
    };

    day.roads.forEach((road) => {
      const timeRange = `${road.startHour} - ${road.endHour}`;
      const slot = slotMap[road.type];
      if (slot) row[slot] = timeRange;
    });

    return row;
  });
}
function transformDriverRoadMap(data: IDriverRoadmap): any[] {
  const slotMap: Record<string, string> = {
    MATIN: 'matin',
    MIDI: 'midi',
    APRES_MIDI: 'apresMidi',
    SOIR: 'soir',
  };

  return data.workedDays.map((entry) => {
    const row: any = {
      date: entry.date,
      matin: '—',
      midi: '—',
      apresMidi: '—',
      soir: '—',
      fuelAmount: entry.fuelAmount,
      startMileage: entry.mileageIntervall?.startMileage,
      endMileage: entry.mileageIntervall?.endMileage,
      observation:entry?.observation,
      otherTrips: entry?.otherTrips,
    };

    entry.roads?.forEach((road) => {
      const slot = slotMap[road.type];
      if (slot) {
        row[slot] = `${road.startHour} - ${road.endHour}`;
      }
    });

    return row;
  });
}
type TripCombinedTableProps = {
  date:string;
  driverId: string;
};
export default function TripCombinedTable({date, driverId}:TripCombinedTableProps) {
  const combinedTable = useRoadMapStore((state) => state.combinedTable);
  const getCombinedTable = useRoadMapStore((state) => state.getCombinedTable);

  const driverRoadMapDetails = useRoadMapStore((state) => state.driverRoadMapDetails);
  const getDriverRoadMap = useRoadMapStore((state) => state.getDriverRoadMap);

  const [tableData, setTableData] = useState<
    {
      id: string;
      date: string;
      matin: string;
      midi: string;
      apresMidi: string;
      soir: string;
    }[]
  >([]);
  const [submittedData, setSubmittedData] = useState<
    {
      id: string;
      date: string;
      matin: string;
      midi: string;
      apresMidi: string;
      soir: string;
    }[]
  >([]);

  useEffect(() => {
    const fetchData = async () => {
      await getCombinedTable(5, '2025-06-01');
      await getDriverRoadMap(driverId, date);
    };

    fetchData();
  }, []);

  useEffect(() => {
    if (combinedTable) {
      const transformed = transformCombinedTable(combinedTable);
      setTableData(transformed);
    }
  }, [combinedTable]);

  useEffect(() => {
    if (driverRoadMapDetails) {
      const transformed = transformDriverRoadMap(driverRoadMapDetails);
      setSubmittedData(transformed);
    }
  }, [driverRoadMapDetails]);

  return (
    <WeeklyVerificationPanel
      title="Verification du planning des  trajets effectues et ses donnees de feuille de route soumise"
      tableConfigs={[
        {
          title: 'Planning théorique des trajets effectuées',
          columns: DEFAULT_GEOLOCATION_TABLE_HEAD,
          data: tableData,
          verificationType: VerificationTableType.combinedTable,
          component: ScheduleVerificationTable,
        },
        {
          title: 'Feuille de route soumise',
          columns: DEFAULT_DRIVER_SCHEDULE_TABLE_HEAD,
          data: submittedData,
          verificationType: VerificationTableType.submittedRoadMap,
          component: ScheduleVerificationTable,
        },
      ]}
      date={date}
    />
  );
}
