import React, { useState } from 'react';
import { TableCell, Box, TextField, Button } from '@mui/material';
import { PeriodType } from '@/shared/types/roadMap';
import { StyledTextField } from '@/shared/components/table/styles';


interface ValidationCombinedTableProps {
  routeType: PeriodType;
  combinedRouteTime: string | null;
  driverRouteTime: string | null;
  dayId: number;
  onTimeChange: (routeType: PeriodType, newTime: string, timeType: 'start' | 'end') => void;
  timeType: 'start' | 'end';
}

const ValidationCombinedTableCell: React.FC<ValidationCombinedTableProps> = ({
  routeType,
  combinedRouteTime,
  driverRouteTime,
  dayId,
  onTimeChange,
  timeType,
}) => {
  const [selectedTime, setSelectedTime] = useState(combinedRouteTime ?? '');
  const selectTime = (time: string) => {
    onTimeChange(routeType, time, timeType);
    setSelectedTime(time);
  };
  const handleSelectedTimeChange = (event: React.ChangeEvent<HTMLInputElement>) => {
    const time = event.target.value;
    setSelectedTime(time);
    onTimeChange(routeType, time, timeType);
    console.log('Child updates:', { routeType, time, timeType });
  };
  return (
    <TableCell>
      <Box sx={{ display: 'flex', alignItems: 'center', gap: 1 }}>
        <Box sx={{ display: 'flex', flexDirection: 'column' , gap: 0.2}}>
          {combinedRouteTime ? (
            <Button
              onClick={() => selectTime(combinedRouteTime)}
              sx={{ backgroundColor: '#c084fc' , display: 'flex', color:'white'}}
            >
              {combinedRouteTime}
            </Button>
          ) : (
            <Button disabled sx={{ backgroundColor: '#c084fc' , display: 'flex', color:'white'}}>
              {'--:--'}
            </Button>
          )}
          {driverRouteTime ? (
            <Button onClick={() => selectTime(driverRouteTime)} sx={{ backgroundColor: '#93c5fd',  display: 'flex', color:'white' }}>
              {driverRouteTime}
            </Button>
          ) : (
            <Button disabled sx={{ backgroundColor: '#93c5fd' , display: 'flex', color:'white'}}>
              {'--:--'}
            </Button>
          )}
        </Box>

        <StyledTextField
          variant="outlined"
          value={selectedTime}
          onChange={handleSelectedTimeChange}
          sx={{ minWidth: '50px' }}
          placeholder="--:--"
          inputProps={{
            style: { textAlign: 'center' },
          }}
        />
      </Box>
    </TableCell>
  );
};

export default ValidationCombinedTableCell;
