'use client';

import { HeaderCellWidthColor } from '@/shared/components/form/style';
import RoadMapValidationTable from '@/shared/components/roadmap/roadmap-validation-table';
import { CustomColumn } from '@/shared/components/roadmap/types';
import { Box, TableHead, TableRow } from '@mui/material';
import React from 'react';

export interface ValidationTableConfig {
  trajets: {
    id: string;
    label: string;
  }[];
  additionalColumns?: {
    id: string;
    label: string;
    align?: 'left' | 'center' | 'right';
  }[];
  dates: string[];
}

export default function ValidationCombinedTableHeader() {
  return (
    <TableHead>
      <TableRow>
        <HeaderCellWidthColor></HeaderCellWidthColor>
        {Array.from({ length: 4 }, (_, index) => (
          <HeaderCellWidthColor align="center" colSpan={2} key={index}>
            Trajet {index + 1}
          </HeaderCellWidthColor>
        ))}
        <HeaderCellWidthColor colSpan={2}></HeaderCellWidthColor>
      </TableRow>
      <TableRow>
        <HeaderCellWidthColor></HeaderCellWidthColor>
        {Array.from({ length: 4 }).map((_, index) => (
          <React.Fragment key={`header-${index}`}>
            <HeaderCellWidthColor align="center">Début</HeaderCellWidthColor>
            <HeaderCellWidthColor align="center">Fin</HeaderCellWidthColor>
          </React.Fragment>
        ))}
        <HeaderCellWidthColor colSpan={2}></HeaderCellWidthColor>
      </TableRow>
    </TableHead>
  );
}
