import { Box, Typography, Stack } from '@mui/material';
import {
  faBuilding,
  faCircleNotch,
  faUserTie,
  faHashtag,
  faIdCardAlt,
  faFileContract,
  faComment,
} from '@fortawesome/free-solid-svg-icons';
import FontAwesome from '@/shared/components/fontawesome';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { pxToRem } from '@/shared/theme/typography';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
import { DriverRoadMapDetailsDTO } from '@/shared/types/roadMap';

type Props = {
  isRouteSheetInValidation?: boolean;
  data: DriverRoadMapDetailsDTO | null;
};

const DriverRoadMapDetails = ({ isRouteSheetInValidation = true, data }: Props) => {
  return (
    <Box sx={{ bgcolor: 'white', borderRadius: '12px', pb: '30px' }}>
      <Typography
        sx={{
          textAlign: 'center',
          p: 3,
          fontSize: pxToRem(30),
          color: 'primary.main',
          fontWeight: (theme) => theme.typography.fontWeightBold,
        }}
      >
        {data?.name ?? 'Feuille de route Juin 2025'}
      </Typography>

      <Stack direction="row" sx={{ px: 3 }} justifyContent="space-between">
        <Stack spacing={1}>
          <Stack direction="row" alignItems="center" spacing={1}>
            <FontAwesome icon={faUserTie} color="primary.main" width={16} />
            <Typography>Prénom : {data?.driverName.split(" ")[0]  ?? 'Benoit'}</Typography>
          </Stack>

          <Stack direction="row" alignItems="center" spacing={1}>
            <FontAwesome icon={faUserTie} color="primary.main" width={16} />
            <Typography>Nom : {data?.driverName.split(" ")[1] ?? 'Hilion'}</Typography>
          </Stack>

          <Stack direction="row" alignItems="center" spacing={1}>
            <FontAwesome icon={faHashtag} color="primary.main" width={16} />
            <Typography>
              Num carte carburant : {data?.cardNumber ?? 'TOTAL-0012-3456789'}
            </Typography>
          </Stack>

          <Stack direction="row" alignItems="center" spacing={1}>
            <FontAwesome icon={faIdCardAlt} color="primary.main" width={16} />
            <Typography>Immatriculation : {data?.immatriculation ?? 'GH-571-WA'}</Typography>
          </Stack>

          <Stack direction="row" alignItems="center" spacing={1}>
            <FontAwesome icon={faFileContract} color="primary.main" width={16} />
            <Typography>Num licence : {data?.licenceNumber ?? '2427'}</Typography>
          </Stack>
        </Stack>

        <Stack spacing={1.5}>
          <Stack direction="row" alignItems="flex-start" spacing={1}>
            <FontAwesome icon={faBuilding} color="primary.main" width={16} />
            <Box>
              <Typography>{data?.departementName ?? 'departement 1-1'}</Typography>
              <Typography>
                {data?.departementAddress ?? 'Departement 1-1 Street , 22222 City D, Country D '}
              </Typography>
            </Box>
          </Stack>
        </Stack>
      </Stack>

      <ConditionalComponent isValid={isRouteSheetInValidation}>
        <Box
          sx={{
            mt: 3,
            p: 1.5,
            bgcolor: 'rgba(255, 0, 0, 0.05)',
            borderRadius: '12px',
            display: 'flex',
            alignItems: 'center',
            gap: 1,
          }}
        >
          <FontAwesomeIcon icon={faCircleNotch} spin color="red" />
          <Typography color="error.main">Feuilles de route en cours de validation</Typography>
        </Box>
      </ConditionalComponent>
    </Box>
  );
};

export default DriverRoadMapDetails;
