'use client';
import {
  Typography,
  Dialog,
  DialogTitle,
  DialogContent,
  List,
  ListItem,
  ListItemIcon,
  Divider,
  ListItemText,
  IconButton,
} from '@mui/material';
import {
  faCar,
  faClock,
  faClose,
  faLocationDot,
  faRoad,
  faTimes,
} from '@fortawesome/free-solid-svg-icons';
import { _mockTripRoutes } from '@/shared/_mock/_preparationCircuit';
import FontAwesome from '@/shared/components/fontawesome';
import { GeolocTableRoute } from '@/shared/components/roadmap/types';
import dayjs from 'dayjs';
import 'dayjs/locale/fr';

dayjs.locale('fr');
interface GeolocModalProps {
  open: any;
  onClose: () => void;
  timeDetails: GeolocTableRoute | null;
}

export default function GeolocModal({ open, onClose, timeDetails }: GeolocModalProps) {
  
  if (!timeDetails) return null;
  return (
    <Dialog open={open} onClose={onClose} fullWidth maxWidth="sm">
      <DialogTitle sx={{ m: 0, p: 2, backgroundColor: 'primary.second' }}>
        <Typography
          variant="h5"
          component="div"
          sx={{
            color: 'primary.main',
            fontWeight: 700,
          }}
        >
          Détails du Trajet
        </Typography>
        <IconButton
          aria-label="close"
          onClick={onClose}
          sx={{
            position: 'absolute',
            right: 8,
            top: 8,
            color: 'text.secondary',
          }}
        >
          <FontAwesome icon={faClose} sx={{ color: 'primary.main' }} />
        </IconButton>
      </DialogTitle>
      <DialogContent dividers>
        <List>
          <ListItem>
            <ListItemIcon>
              <FontAwesome icon={faClock} sx={{ color: 'primary.main' }} />
            </ListItemIcon>
            <ListItemText
              primary="Date de départ"
              secondary={dayjs(timeDetails.departureDate).format('dddd DD MMMM YYYY | HH:mm')}
            />
          </ListItem>
          <Divider variant="inset" component="li" />
          <ListItem>
            <ListItemIcon>
              <FontAwesome icon={faClock} sx={{ color: 'primary.main' }} />
            </ListItemIcon>
            <ListItemText primary="Date d'arrivée" secondary={dayjs(timeDetails.arrivalDate).format('dddd DD MMMM YYYY | HH:mm')} />
          </ListItem>
          <Divider variant="inset" component="li" />
          <ListItem>
            <ListItemIcon>
              <FontAwesome icon={faCar} sx={{ color: 'primary.main' }} />
            </ListItemIcon>
            <ListItemText primary="Véhicule" secondary={timeDetails.carRegistration} />
          </ListItem>
          <Divider variant="inset" component="li" />
          <ListItem>
            <ListItemIcon>
              <FontAwesome icon={faRoad} sx={{ color: 'primary.main' }} />
            </ListItemIcon>
            <ListItemText primary="Distance" secondary={`${timeDetails.distance} km`} />
          </ListItem>
          <Divider variant="inset" component="li" />
          <ListItem>
            <ListItemIcon>
              <FontAwesome icon={faLocationDot} sx={{ color: 'primary.main' }} />
            </ListItemIcon>
            <ListItemText primary="Adresse de départ" secondary={timeDetails.departureLocation} />
          </ListItem>
          <Divider variant="inset" component="li" />
          <ListItem>
            <ListItemIcon>
              <FontAwesome icon={faLocationDot} sx={{ color: 'primary.main' }} />
            </ListItemIcon>
            <ListItemText primary="Adresse d'arrivée" secondary={timeDetails.arrivalLocation} />
          </ListItem>
        </List>
      </DialogContent>
    </Dialog>
  );
}
