import React from 'react';
import { Box, Paper, Stack, Typography } from '@mui/material';
import { faClock, faLocationDot } from '@fortawesome/free-solid-svg-icons';
import FontAwesome from '@/shared/components/fontawesome';

interface GeolocRoute {
  startTime: string;
  endTime: string;
  departure: string;
  destination: string;
}

interface PeriodData {
  label: string;
  timeRange: string;
  routes: GeolocRoute[];
}

interface GeolocTableProps {
  periodRoutes: PeriodData[];
}

export const GeolocTable: React.FC<GeolocTableProps> = ({ periodRoutes }) => {
  return (
    <Box
      sx={{
        overflowY: 'auto',
        pr: 1,
        display: 'flex',
        flexDirection: 'column',
        gap: 2,
        maxHeight: '200px',
        width: '100%',
      }}
    >
      {periodRoutes.map((period, index) => (
        <Paper
          key={index}
          elevation={1}
          sx={{
            p: 2,
            borderRadius: 2,
            bgcolor: '#fdfdff',
            width: '100%',
          }}
        >
          <Stack direction="row" alignItems="center" spacing={1} mb={1}>
            <FontAwesome icon={faClock} color="primary.main" width={16} />
            <Typography variant="subtitle1" fontWeight="bold" color="primary.main">
              {period.label}
              <Typography component="span">({period.timeRange})</Typography>
            </Typography>
          </Stack>

          {period.routes.length === 0 ? (
            <Typography color="text.secondary" ml={4}>
              Aucun trajet disponible
            </Typography>
          ) : (
            <Stack direction="column" spacing={1} alignItems="left" pl={4}>
              {period.routes.map((route, idx) => (
                <Box key={idx} mt={1}>
                  <Stack direction="row" spacing={1} alignItems="left" pl={4}>
                    <FontAwesome icon={faClock} color="primary.main" width={16} />
                    <Typography  variant="body2" color="text.primary">
                      Début : {route.startTime} → Arrivée : {route.endTime}
                    </Typography>
                  </Stack>
                  <Stack direction="row" spacing={1} alignItems="left" mt={0.5} pl={4}>
                    <FontAwesome icon={faLocationDot} color="primary.main" width={16} />
                    <Typography>De : {route.departure}</Typography>
                  </Stack>

                  <Stack direction="row" spacing={1} alignItems="left" mt={0.5} pl={4}>
                    <FontAwesome icon={faLocationDot} color="primary.main" width={16} />
                    <Typography>À : {route.destination}</Typography>
                  </Stack>
                </Box>
              ))}
            </Stack>
          )}
        </Paper>
      ))}
    </Box>
  );
};
