'use client';
import {
  Typography,
  Dialog,
  DialogTitle,
  DialogContent,
  List,
  ListItem,
  ListItemIcon,
  Divider,
  IconButton,
  Grid,
} from '@mui/material';
import { faClock, faClose, faGasPump, faNoteSticky, faRoad } from '@fortawesome/free-solid-svg-icons';
import { _mockTripRoutes } from '@/shared/_mock/_preparationCircuit';
import FontAwesome from '@/shared/components/fontawesome';
import { OtherTrip } from '@/shared/types/roadMap';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

interface SubbmitedRoadMapModalProps {
  open: any;
  onClose: () => void;
  startKm: number;
  endKm: number;
  fuelAmount: number;
  observation: string;
  otherTrips: OtherTrip[];
}

export default function SubbmitedRoadMapModal({
  open,
  onClose,
  startKm,
  endKm,
  fuelAmount,
  observation,
  otherTrips,
}: SubbmitedRoadMapModalProps) {
  return (
    <Dialog open={open} onClose={onClose} fullWidth maxWidth="sm">
      <DialogTitle sx={{ m: 0, p: 2, backgroundColor: 'primary.second' }}>
        <Typography
          variant="h5"
          component="div"
          sx={{
            color: 'primary.main',
            fontWeight: 700,
          }}
        >
          Détails du Trajet
        </Typography>
        <IconButton
          aria-label="close"
          onClick={onClose}
          sx={{
            position: 'absolute',
            right: 8,
            top: 8,
            color: 'text.secondary',
          }}
        >
          <FontAwesome icon={faClose} sx={{ color: 'primary.main' }} />
        </IconButton>
      </DialogTitle>
      <DialogContent dividers>
        <List>
          <Grid container justifyContent="space-between" alignItems="center">
            <ListItem>
              <ListItemIcon>
                <FontAwesome icon={faRoad} sx={{ color: 'primary.main' }} />
              </ListItemIcon>
              <Grid item xs={6}>
                <Typography variant="subtitle1" component="span">
                  {'Nombre de kilomètres en début de journée'}
                </Typography>
              </Grid>
              <Grid item xs={6}>
                <Typography variant="body2" color="textSecondary" style={{ textAlign: 'right' }}>
                  {startKm}
                </Typography>
              </Grid>
            </ListItem>
            <Divider variant="inset" component="li" />
            <ListItem>
              <ListItemIcon>
                <FontAwesome icon={faRoad} sx={{ color: 'primary.main' }} />
              </ListItemIcon>
              <Grid item xs={6}>
                <Typography variant="subtitle1" component="span">
                  {'Nombre de kilomètres en fin de journée'}
                </Typography>
              </Grid>
              <Grid item xs={6}>
                <Typography variant="body2" color="textSecondary" style={{ textAlign: 'right' }}>
                  {endKm}
                </Typography>
              </Grid>
            </ListItem>
            <Divider variant="inset" component="li" />
            <ListItem>
              <ListItemIcon>
                <FontAwesome icon={faGasPump} sx={{ color: 'primary.main' }} />
              </ListItemIcon>
              <Grid item xs={6}>
                <Typography variant="subtitle1" component="span">
                  {'Montant carburant'}
                </Typography>
              </Grid>
              <Grid item xs={6}>
                <Typography variant="body2" color="textSecondary" style={{ textAlign: 'right' }}>
                  {`${fuelAmount} €`}
                </Typography>
              </Grid>
            </ListItem>
            <ConditionalComponent isValid={otherTrips?.length > 0} defaultComponent={null}>
            <Divider variant="inset" component="li" />
            <ListItem>
              <ListItemIcon>
                <FontAwesome icon={faClock} sx={{ color: 'primary.main' }} />
              </ListItemIcon>
              <Grid item xs={6}>
                <Typography variant="subtitle1" component="span">
                  {'Autres trajets :'}
                </Typography>
              </Grid>
              <Grid item xs={6}>
                {otherTrips.map((trip, index) => (
                  <Typography key={index} variant="body2" color="textSecondary" style={{ textAlign: 'right' }}>
                    {trip.type === 'GARAGE_VISIT' ? 'Visite garage' : 'Visite médicale'} : {trip.startHour} - {trip.endHour}
                  </Typography>
                ))}
              </Grid>
            </ListItem>
        </ConditionalComponent>

        <ConditionalComponent isValid={!!observation} defaultComponent={null}>
            <Divider variant="inset" component="li" />
            <ListItem>
              <ListItemIcon>
                <FontAwesome icon={faNoteSticky} sx={{ color: 'primary.main' }} />
              </ListItemIcon>
              <Grid item xs={6}>
                <Typography variant="subtitle1" component="span">
                  {'Observation :'}
                </Typography>
                
              </Grid>
              <Grid item xs={6}>
                <Typography variant="body2" color="textSecondary" style={{ textAlign: 'right' }}>
                  {observation}
                </Typography>
              </Grid>
            </ListItem>
          </ConditionalComponent>
          </Grid>
        </List>
      </DialogContent>
    </Dialog>
  );
}
