'use client';
import { Typography, Grid, Dialog, DialogTitle, DialogContent, IconButton } from '@mui/material';
import { faClose } from '@fortawesome/free-solid-svg-icons';
import dynamic from 'next/dynamic';
import { MapType } from '@/shared/types/Maps';
import { _mockTripRoutes } from '@/shared/_mock/_preparationCircuit';
import { JourneySummaryDriver } from '@/shared/components/google-maps/journey-summary-driver';
import FontAwesome from '@/shared/components/fontawesome';
import { Box } from '@mui/system';
import { GeolocTable } from './geolocTable';
import { geolocPeriodRoutes, planningVsnRoutes } from '@/shared/_mock/_roadMap';

const MapView = dynamic(() => import('@/shared/components/google-maps/maps'), {
  ssr: false,
});

interface Props {
  open: any;
  onClose: () => void;
}

export default function VsnScheduleModal({ open, onClose }: Props) {
  return (
    <Dialog
      open={open}
      onClose={onClose}
      fullWidth
      maxWidth="xl"
      sx={{ width: '100%', maxWidth: 'none', mx: 'auto', my: 'auto' }}
    >
      <DialogTitle sx={{ m: 0, p: 2, pb: 1 }}>
        <Typography
          variant="h5"
          component="div"
          sx={{
            color: 'primary.main',
            fontWeight: 700,
          }}
        >
          Détails du Trajet
        </Typography>
        <IconButton
          aria-label="close"
          onClick={onClose}
          sx={{
            position: 'absolute',
            right: 8,
            top: 8,
            color: 'text.secondary',
          }}
        >
          <FontAwesome icon={faClose} sx={{ color: 'primary.main' }} />
        </IconButton>
      </DialogTitle>
      <DialogContent dividers>
        <Typography
          variant="h6"
          sx={{ fontWeight: 'bold', color: 'primary.main', textAlign: 'center', mb: 2 }}
        >
          La carte du planning du chauffeur et des données de géolocalisation
        </Typography>

        <Grid container spacing={2}>
          <Grid item xs={12} md={5}>
            <Box sx={{ display: 'flex', flexDirection: 'column', gap: 2 }}>
              <Typography
                variant="h6"
                sx={{ fontWeight: 'bold', color: 'primary.main', textAlign: 'left', mb: 2 }}
              >
                Trajets du Planning vsn
              </Typography>
              <Box
                sx={{
                  overflowX: 'auto',
                  display: 'flex',
                  gap: 2,
                  px: 2,
                  py: 1,
                  bgcolor: '#f5f3fe',
                  borderRadius: 2,
                }}
              >
                <JourneySummaryDriver routes={planningVsnRoutes} />
              </Box>

              <Box sx={{ mt: 1 }}>
                <Typography
                  variant="h6"
                  sx={{ fontWeight: 'bold', color: 'primary.main', textAlign: 'left', mb: 2 }}
                >
                  Trajets de Géolocalisation
                </Typography>
                <Box
                  sx={{
                    overflowX: 'auto',
                    display: 'flex',
                    gap: 2,
                    px: 2,
                    py: 1,
                    bgcolor: '#f5f3fe',
                    borderRadius: 2,
                  }}
                >
                  <GeolocTable periodRoutes={geolocPeriodRoutes} />
                </Box>
              </Box>
            </Box>
          </Grid>

          <Grid item xs={12} md={7}>
            <MapView height="600px" Submodule={MapType.CIRCUIT} routes={_mockTripRoutes} />
          </Grid>
        </Grid>
      </DialogContent>
    </Dialog>
  );
}
