'use-client';

import FormContainer from '@/layouts/form/form-container';
import DriverRoadMapDetails from '../components/validate-roadmap/driver-roadmap-details';
import { Box } from '@mui/system';
import DriverCombinedTable from '../components/validate-roadmap/combined-table-driver';
import TripCombinedTable from '../components/validate-roadmap/combined-table-trip';
import FinalResultTable from '../components/validate-roadmap/FinalResultTable';
import { useEffect } from 'react';
import { useRoadMapStore } from '@/shared/api/stores/roadMapStore';

interface OldRoadMapDetailsViewProps {
  id?: number;
  date: string;
  driverId : string;
}
export default function OldRoadMapDetailsView({ id ,date ,driverId}: OldRoadMapDetailsViewProps) {
  const { getOldValidattedRoadMapDetails, oldValidattedRoadMapDetails } = useRoadMapStore();
  useEffect(() => {
    const fetchData = async () => {
      if (id) {
        try {
          await getOldValidattedRoadMapDetails(id);
        } catch (error) {
          console.error('Error fetching details:', error);
        }
      } else {
        console.warn('No ID found in searchParams');
      }
    };

    fetchData();
  }, [id]);

  return (
    <FormContainer sx={{ backgroundColor: 'transparent', p: 0 }} hasBorder>
      <DriverRoadMapDetails isRouteSheetInValidation={false} data={oldValidattedRoadMapDetails} />
      <Box sx={{ display: 'flex', flexDirection: 'column', gap: 2, mt: 2 }}>
        <DriverCombinedTable date={date} driverId={driverId} />
        <TripCombinedTable date={date} driverId={driverId} />
        <FinalResultTable showButton={false} />
      </Box>
    </FormContainer>
  );
}
