'use-client';

import FormContainer from '@/layouts/form/form-container';
import DriverRoadMapDetails from '../components/validate-roadmap/driver-roadmap-details';
import { Box, Typography, TextField, Button } from '@mui/material';
import DailyRoadMapAccordionCard from '../components/roadmap-list/old-submitted-roadmap/daily-roadmap-accordion-card';
import { useSearchParams } from 'next/navigation';
import { useEffect } from 'react';
import { useRoadMapStore } from '@/shared/api/stores/roadMapStore';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
import { IOldRoadmap } from '@/shared/types/driver';

interface Props {
  activeTabData: IOldRoadmap;
}

export default function OldSubmittedRoadMapDetailsView({ activeTabData }: Props) {
  const { getOldSubmittedRoadMapDetails, oldSubmittedRoadMapDetails } = useRoadMapStore();

  useEffect(() => {
    const fetchData = async () => {
      if (activeTabData.id) {
        const id = Number(activeTabData.id);
        if (!isNaN(id)) {
          try {
            await getOldSubmittedRoadMapDetails(id);
          } catch (error) {
            console.error('Error fetching details:', error);
          }
        } else {
          console.warn('Invalid ID:', activeTabData.id);
        }
      } else {
        console.warn('No ID found in searchParams');
      }
    };

    fetchData();
  }, [activeTabData.id]);

  return (
    <FormContainer sx={{ backgroundColor: 'transparent', p: 0 }} hasBorder>
      <ConditionalComponent
        isValid={!!oldSubmittedRoadMapDetails}
        defaultComponent={<Typography sx={{ p: 3 }}>Chargement...</Typography>}
      >
        <>
          <DriverRoadMapDetails
            isRouteSheetInValidation={false}
            data={oldSubmittedRoadMapDetails!}
          />
          <Box m={2}>
            {oldSubmittedRoadMapDetails?.workedDays?.length ? (
              oldSubmittedRoadMapDetails.workedDays
                .slice()
                .reverse()
                .map((day, index) => <DailyRoadMapAccordionCard key={index} day={day} />)
            ) : (
              <Typography>Aucune journée de travail trouvée.</Typography>
            )}
          </Box>
        </>
      </ConditionalComponent>
    </FormContainer>
  );
}
