import { Box } from "@mui/material";
import DriverRoadMapDetails from "../components/validate-roadmap/driver-roadmap-details";
import FormContainer from "@/layouts/form/form-container";
import DriverCombinedTable from "../components/validate-roadmap/combined-table-driver";
import TripCombinedTable from "../components/validate-roadmap/combined-table-trip";
import ValidationCombinedTable from "../components/validate-roadmap/combined-table-validation";
import FinalResultTable from "../components/validate-roadmap/FinalResultTable";
import { ValidatedRoadMapArgs } from "@/shared/types/roadMap";
export type ValidateRoadmapViewProps = {
  validatedRoadMapArgs: ValidatedRoadMapArgs;
};
export default function ValidateRoadmapView(validatedRoadMapArgs: ValidateRoadmapViewProps) {
  const dateInput = validatedRoadMapArgs?.validatedRoadMapArgs?.date ?? "";
  const driverId = validatedRoadMapArgs?.validatedRoadMapArgs?.driverId ?? "";

  const date = dateInput ? `${dateInput}-01` : "";
  return (
    <FormContainer sx={{backgroundColor: 'transparent',p:0}} hasBorder >
      <DriverRoadMapDetails data={null} />
      <Box sx={{ display: 'flex', flexDirection: 'column', gap: 2, mt: 2 }}>
        <DriverCombinedTable date={date} driverId={driverId} />
        <TripCombinedTable date={date} driverId={driverId}   />
        <ValidationCombinedTable date={date} driverId={driverId}  />
        <FinalResultTable showButton={true} />
      </Box>
    </FormContainer>
  );
}
