'use client';

import React, { useState } from 'react';
import { Alert, Box, CircularProgress } from '@mui/material';

import { FormFieldType, ModeType, TableColumn, TableType } from '@/shared/types/common';
import { TripCircuitDetails } from '@/shared/types/circuit';
import { useJsApiLoader } from '@react-google-maps/api';
import DetailsTrajet from '@/shared/sections/trajet/components/details-trajet';
import DetailsDriverTrip from '../details-driver-trip';

interface TrajetFormProps {
  trajet: TripCircuitDetails;
  handleView: (item: TripCircuitDetails) => void;
}

const GOOGLE_MAPS_LIBRARIES: ('places' | 'geometry')[] = ['places', 'geometry'];

function DetailsTrajetWithGoogleLoader(props: any) {
  const { isLoaded, loadError } = useJsApiLoader({
    id: 'google-map-script',
    googleMapsApiKey: process.env.NEXT_PUBLIC_GOOGLE_MAPS_API_KEY || '',
    libraries: GOOGLE_MAPS_LIBRARIES,
  });

  if (loadError) {
    return (
      <Box sx={{ display: 'flex', justifyContent: 'center', alignItems: 'center', height: '100%' }}>
        <Alert severity="error"> Erreur de chargement Google Maps: {loadError.message}</Alert>
      </Box>
    );
  }

  if (!isLoaded) {
    return (
      <Box sx={{ display: 'flex', justifyContent: 'center', alignItems: 'center', height: '100%' }}>
        <CircularProgress />
      </Box>
    );
  }

  return <DetailsDriverTrip {...props} isGoogleLoaded={isLoaded} />;
}

export default function DriverTripForm({
  trajet, 
  handleView,
}: TrajetFormProps) {
  const [formData, setFormData] = useState<TripCircuitDetails>(trajet!);



  return (
    <>
      <DetailsTrajetWithGoogleLoader
        trajetId={formData.id}
        trajet={formData}
        handleView={handleView}
      />
    </>
  );
}
