import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import TableActionColumn from '@/shared/components/table/table-action-column';
import { ContratStyledRow, StatusChip } from '@/shared/sections/contract/styles';
import { useTheme } from '@mui/material/styles';
import { TableColumn } from '@/shared/types/common';
import { dateFormat, formatDate } from '@/utils/format-time';
import { getLabel } from '@/shared/_mock';
import { _STATUT_ROUTE_OPTIONS } from '@/shared/_mock/_suiviTrajet';
import { _TRAJET_TYPE } from '@/shared/_mock/_trajets';
import { Box, Chip, IconButton } from '@mui/material';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import FontAwesome from '@/shared/components/fontawesome';
import { ActionsIconButton } from '@/shared/theme/css';
import { faFolder, faFolderOpen, faMap, faMapMarkedAlt } from '@fortawesome/free-solid-svg-icons';
import { useBoolean } from '@/hooks';
import SvgColor from '@/shared/components/svg-color';
import StatusMenu from '@/shared/components/table/StatusMenu';
import { getStatusColor } from '@/shared/sections/rh/styles';
import { AntSwitch } from '@/shared/components/table/styles';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
import { DailyTripDTO, TripCircuitDetails } from '@/shared/types/circuit';

type Props = {
  handleEdit: (item: TripCircuitDetails) => void;
  handleDetails: (trajetId: string) => void;
  handleCopy: (item: TripCircuitDetails) => void;
  selected: boolean;
  row: DailyTripDTO;
  dense: boolean;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
  onStatusChange: (row: DailyTripDTO, newStatus: string, field: keyof DailyTripDTO) => void;
};

const TOOLTIP_TITLES = {
  duplicate: 'Copier trajet',
  active: 'Trajet actif',
  inActive: 'Trajet inactif',
};

const SUBMISSION_OPTIONS: any[] = [
  {
    value: 'true',
    label: 'Affecté',
    color: '#36B37E',
    backgroundColor: '#E9FBF0',
  },
  {
    value: 'false',
    label: 'Non Affecté',
    color: '#FF3434',
    backgroundColor: '#FFE1E1',
  },
];
export default function SuiviTrajetTableRow({
  dense,
  row,
  handleEdit,
  handleDetails,
  handleCopy,
  selected,
  onSelectRow,
  columns,
  onStatusChange,
}: Props) {
  const theme = useTheme();
  const renderCellContent = (columnId: string, value: any) => {
      if (value === null || value === undefined) return ''; 
    switch (columnId) {
      case 'isAssigned':
        return(
          <Chip
                label={value === true || value === 'true' ? 'Affecté' : 'Non Affecté'}
                size="medium"
                sx={{
                  backgroundColor: value === true || value === 'true' ? '#E9FBF0' : '#FFE1E1',
                  color: value === true || value === 'true' ? '#36B37E' : '#FF3434',
                  fontWeight: 500,
                  minWidth: '110px',
                  textAlign: 'center',
                  borderRadius: '8px',
                  height: '40px',
                }}
              />
           
                  )
        case 'tripType':
              const getTripTypeConfig = (value: string) => {
                switch (value) {
                  case 'NORMAL':
                    return {
                      label: 'Trajet Normal',
                      backgroundColor: '#F4F6F8',
                      color: '#637381',
                    };
                  case 'PERSONALIZED':
                    return {
                      label: 'Trajet Personnalisé',
                      backgroundColor: '#F4F6F8',
                      color: '#637381',
                    };
                  default:
                    return {
                      label: value,
                      backgroundColor: '#F4F6F8',
                      color: '#637381',
                    };
                }
              };
              const tripTypeConfig = getTripTypeConfig(value);
              return (
                <StatusChip
                  label={tripTypeConfig.label}
                  status={value}
                  theme={theme}
                  size="small"
                  sx={{
                    backgroundColor: tripTypeConfig.backgroundColor,
                    color: tripTypeConfig.color,
                    fontWeight: 500,
                  }}
                />
              );
                 case 'sens':
                      const firstLetter = value.charAt(0).toUpperCase();
                      const label = firstLetter === 'D' ? 'A' : firstLetter;
                      return (
                        <StatusChip
                          label={label}
                          status={value}
                          theme={theme}
                          size="small"
                          sx={{
                            backgroundColor: '#F4F6F8',
                            color: '#637381',
                            fontWeight: 'bold',
                          }}
                        />
                      );
      default:
        return value;
    }
  };

  return (
    <ContratStyledRow hover style={{ cursor: 'pointer' }}>
      {columns
        .filter((column) => column.id !== 'isActive')
        .map((column: any, index: number) => (
          <TableCell
            onDoubleClick={() => handleDetails(row.id)}
            key={column.id}
            align={column.align || 'left'}
            sx={{
              whiteSpace: 'nowrap',
              ...(index === 0 && {
                position: 'relative',
              }),
              py: column.id === 'statut' || column.id === 'typeTrajet' ? 0 : dense ? 1 : 2,
            }}
          >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
                src="/assets/icons/ic_border.svg"
                sx={{
                  position: 'absolute',
                  top: 0,
                  left: -4,
                  height: '100%',
                  color: getStatusColor(row.title),
                }}
              />
            </ConditionalComponent>
            {renderCellContent(column.id, row[column.id as keyof DailyTripDTO])}
          </TableCell>
        ))}
    </ContratStyledRow>
  );
}
