import { _CIRCUIT_STATUS } from "@/shared/_mock/_circuit";
import { _BINARY_Qst } from "@/shared/_mock/_trajets";
import { AmendmentCircuit } from "@/shared/types/ammendment-circuit";
import { circuitStateOptions, IAvenant, ICircuit } from "@/shared/types/circuit";
import { FormFieldType } from "@/shared/types/common";
import { BinaryQuestion } from "@/shared/types/trajet";
import { faAddressCard, faEuro, faHashtag, faStickyNote, faTag } from "@fortawesome/free-solid-svg-icons";

export const mainAvenantformFields: FormFieldType<AmendmentCircuit>[] = [
    {
      name: 'code',
      label: 'Code de l\'avenant',
      type: 'text',
      icon: faHashtag,
    },
    {
      name: 'title',
      label: 'Intitulé',
      type: 'text',
      icon: '/assets/icons/menu/ic_exploitation.svg',
      required: true,
    },
]


export const detailsAvenantformFields: FormFieldType<AmendmentCircuit>[] = [
    {
        name: 'circuitState',
        label: 'État du circuit',
        type: 'select',
        options: circuitStateOptions,
      },
      {
        name: 'pickupAddress',
        label: 'Prise en charge',
        type: 'address',
        placeholder: 'Entrez une adresse',
      },
      {
        name: 'establishment',
        label: 'Établissement principal',
        type: 'text',
        placeholder: 'Entrez un nom',
        required: true,
        icon: '/assets/icons/form/ic_building.svg',
      },
      {
        name: 'startDate',
        label: 'Date de début',
        type: 'date',
        required: true,
      },
      {
        name: 'calculationType',
        label: 'Type de calcul',
        type: 'text',
        placeholder: 'Calcul Automatique',
      },
      {
        name: 'circuitEndDate',
        label: 'Date de fin',
        type: 'date',
        required: true,
      },
      {
        name: 'driver',
        label: 'Chauffeur',
        type: 'text',
        placeholder: 'Entrez un nom',
        icon: faAddressCard,
      },
      {
        name: 'priceGrid',
        label: 'Grille de prix',
        type: 'text',
        placeholder: '0',
        icon: faEuro,
      },

      {
        name: 'contractColor',
        label: 'Couleur de catégorisation',
        type: 'color',
        placeholder: 'Choisissez une couleur',
        required: true,
        icon: '/assets/icons/form/ic_palette.svg',
      },
      {
        name: 'amendmentObject',
        label: "Observation",
        placeholder:"Ajoutez une note ou une observation",
        type: 'textarea',
        icon: faStickyNote,
      }
    ];
